<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Test\Integration;







use Apaczka\Api\Client\ApiClient;



use Apaczka\Api\Client\ApiClientFactory as BaseApiClientFactory;



use Apaczka\Api\Client\Exception\InvalidArgumentException;







class ApiClientFactory



{



	public function create(): ApiClient



	{



		$id = getenv('APACZKA_API_ID');



		$secret = getenv('APACZKA_API_SECRET');







		if (!$id || !$secret) {



			throw new InvalidArgumentException('Env "APACZKA_API_ID" and "APACZKA_API_SECRET" must be set. Do you forgot to export it ?');



		}







		return BaseApiClientFactory::createDefault($id, $secret);



	}



}



