<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Transformer;







use Apaczka\Api\Client\Helper\Compositor;



use Apaczka\Api\Client\Model\PackageTypeEnum;



use Apaczka\Api\Client\Model\Price;



use Apaczka\Api\Client\Model\Shipment;



use stdClass;







/**



 * @implements TransformerInterface<?stdClass, ?Shipment>



 */



class ShipmentTransformer implements TransformerInterface



{



	private PriceTransformer $priceTransformer;







	public function __construct()



	{



		$this->priceTransformer = new PriceTransformer();



	}







	/**



	 * @param ?stdClass $object



	 * @return ?Shipment



	 */



	public function transform($object)



	{



		if (null === $object) {



			return null;



		}







		return new Shipment(



			new PackageTypeEnum($object->shipment_type_code),



			(float) $object->weight,



			(float) $object->length,



			(float) $object->width,



			(float) $object->height,



			(bool) $object->is_nstd,



			$object->content ?? null,



			$object->comment ?? null,



			$object->weight_billable ? (float) $object->weight_billable : null,



			$this->priceTransformer->transform($object),



			$object->waybillNumber ?? null



		);



	}







	/**



	 * @param ?Shipment $object



	 * @return ?stdClass



	 */



	public function revert($object)



	{



		if (null === $object) {



			return null;



		}







		$s = new stdClass();



		$s->shipment_type_code = (string) $object->getPackageTypeEnum();



		$s->weight = (string) $object->getWeight();



		//$s->weight_billable = (string) $object->getWeightBillable();



		//$s->length = (string) $object->getLength();



		//$s->width = (string) $object->getWidth();



		//$s->height = (string) $object->getHeight();



		$s->content = (string) $object->getContent();



		$s->comment = (string) $object->getComment();



		$s->waybill_number = (string) $object->getWaybillNumber();



		$s->is_nstd = (string) $object->isOversize();



		$s->dimension1 = (string) $object->getLength();



		$s->dimension2 = (string) $object->getWidth();



		$s->dimension3 = (string) $object->getHeight();



		Compositor::compose($s, $this->priceTransformer->revert($object->getPrice()));







		return $s;



	}



}



