<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Transformer;







use Apaczka\Api\Client\Model\Price;



use stdClass;







/**



 * @implements TransformerInterface<?stdClass, ?Price>



 */



class PriceTransformer implements TransformerInterface



{



	public function transform($object)



	{



		if (null === $object) {



			return null;



		}







		$tax = null;







		if (isset($object->price_vat)) {



			$tax = (int) $object->price_vat;



		} elseif (isset($object->price_var)) {



			$tax = (int) $object->price_var;



		}







		return new Price(



			isset($object->price) ? (int) $object->price : 0,



			isset($object->price_gross) ? (int) $object->price_gross : 0,



			$tax,



            isset($object->id) ? (int) $object->id : null,



		);



	}







	/**



	 * @param ?Price $object



	 * @return ?stdClass



	 */



	public function revert($object)



	{



		if (null === $object) {



			return null;



		}







		$s = new stdClass();







		$s->price = $object->getNet();



		$s->price_gross = $object->getGross();



		$s->price_vat = $object->getTax();







		return $s;



	}



}



