<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Transformer;







use Apaczka\Api\Client\Model\PointTypeEnum;







/**



 * @implements TransformerInterface<?string, ?PointTypeEnum>



 */



class PointTypeTransformer implements TransformerInterface



{



	/**



	 * @param ?string $object



	 * @return ?PointTypeEnum



	 */



	public function transform($object)



	{



		if (null === $object) {



			return null;



		}







		return new PointTypeEnum($object);



	}







	/**



	 * @param ?PointTypeEnum $object



	 * @return ?string



	 */



	public function revert($object)



	{



		if (null === $object) {



			return null;



		}







		return (string) $object;



	}



}



