<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Transformer;







use Apaczka\Api\Client\Model\PickupType;



use Apaczka\Api\Client\Model\PickupTypeEnum;



use stdClass;







/**



 * @implements TransformerInterface<?stdClass, ?PickupType>



 */



class PickupTypeTransformer implements TransformerInterface



{



	/**



	 * @param ?stdClass $object



	 * @return ?PickupType



	 */



	public function transform($object)



	{



		if (null === $object) {



			return null;



		}







		return new PickupType(



			new PickupTypeEnum($object->type),



			$object->desc



		);



	}







	/**



	 * @param ?PickupType $object



	 * @return ?stdClass



	 */



	public function revert($object)



	{



		if (null === $object) {



			return null;



		}







		$s = new stdClass();



		$s->type = (string) $object->getTypeEnum();



		$s->desc = $object->getDescription();







		return $s;



	}



}



