<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Transformer;







use Apaczka\Api\Client\Model\Pickup;



use Apaczka\Api\Client\Model\PickupTypeEnum;



use Cassandra\Date;



use DateTimeImmutable;



use DateTimeInterface;



use stdClass;







/**



 * @implements TransformerInterface<?stdClass, ?Pickup>



 */



class PickupTransformer implements TransformerInterface



{



	public function transform($object)



	{



		if (null === $object) {



			return null;



		}







		return new Pickup(



			new PickupTypeEnum($object->type),



			isset($object->date) && null !== $object->date ? new DateTimeImmutable($object->date) : null,



			$object->hours_from ?? null,



			$object->hours_to ?? null,



			$object->address_id ?? null,



			$object->pickup_number ?? null



		);



	}







	/**



	 * @param ?Pickup $object



	 * @return ?stdClass



	 */



	public function revert($object)



	{



		if (null === $object) {



			return null;



		}







		$s = new stdClass();



		$s->type = (string) $object->getTypeEnum();



		$s->date = $object->getDay() instanceof DateTimeInterface ? $object->getDay()->format("Y-m-d") : null;



		$s->hours_from = empty($object->getHourFrom()) ? null : $object->getHourFrom();



		$s->hours_to = empty($object->getHoursTo()) ? null : $object->getHoursTo();



		$s->address_id = $object->getAddressId();



		$s->pickup_number = $object->getNumber();







		return $s;



	}



}



