<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Transformer;







use Apaczka\Api\Client\Model\PackageType;



use Apaczka\Api\Client\Model\PackageTypeEnum;



use stdClass;







/**



 * @implements TransformerInterface<?stdClass, ?PackageType>



 */



class PackageTypeTransformer implements TransformerInterface



{



	/**



	 * @param ?stdClass $object



	 * @return ?PackageType



	 */



	public function transform($object)



	{



		if (null === $object) {



			return null;



		}







		return new PackageType(



			new PackageTypeEnum($object->type),



			$object->desc



		);



	}







	/**



	 * @param ?PackageType $object



	 * @return ?stdClass



	 */



	public function revert($object)



	{



		if (null === $object) {



			return null;



		}







		$s = new stdClass();



		$s->type = (string) $object->getType();



		$s->desc = $object->getDescription();







		return $s;



	}



}



