<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Transformer;







use Apaczka\Api\Client\Model\Option;



use Apaczka\Api\Client\Model\OptionTypeEnum;



use stdClass;







/**



 * @implements TransformerInterface<?stdClass, ?Option>



 */



class OptionTransformer implements TransformerInterface



{



	/**



	 * @param ?stdClass $object



	 * @return ?Option



	 */



	public function transform($object)



	{



		if (null === $object) {



			return null;



		}







		return new Option(



			$object->id,



			new OptionTypeEnum($object->type),



			(string) $object->name,



			isset($object->desc) ? (string) $object->desc : '',



		);



	}







	/**



	 * @param ?Option $object



	 * @return ?stdClass



	 */



	public function revert($object)



	{



		if (null === $object) {



			return null;



		}







		$s = new stdClass();







		$s->id = $object->getId();



		$s->type = (string) $object->getType();



		$s->name = $object->getName();



		$s->desc = $object->getDescription();







		return $s;



	}



}



