<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Transformer;







use Apaczka\Api\Client\Model\Address;



use Apaczka\Api\Client\Model\GeoCords;



use stdClass;







/**



 * @implements TransformerInterface<?stdClass, ?Address>



 */



class AddressTransformer implements TransformerInterface



{



	public function transform($object)



	{



		if (null === $object) {



			return null;



		}







		$cords = isset($object->longitude) && isset($object->latitude) && null !== $object->longitude && null !== $object->latitude



		   ? new GeoCords((float) $object->latitude, (float) $object->latitude)



		   : null;







		return new Address(



			$object->country_code ?? null,



			$object->name ?? null,



			$object->line1 ?? null,



			$object->line2 ?? null,



			$object->postal_code ?? null,



			$object->city ?? null,



			$cords,



			$object->is_residential ?? false,



			$object->contact_person ?? null,



			$object->email ?? null,



			$object->phone ?? null,



			isset($object->foreign_address_id) ? (string) $object->foreign_address_id : null,



		);



	}







	/**



	 * @param ?Address $object



	 * @return ?stdClass



	 */



	public function revert($object)



	{



		if (null === $object) {



			return null;



		}







		$s = new stdClass();



		$s->id = $object->getId();



        $s->foreign_address_id = $object->getForeignAddressId();



		$s->name = $object->getName();



		$s->line1 = $object->getLine1();



		$s->line2 = $object->getLine2();



		$s->postal_code = $object->getPostalCode();



		$s->country_code = $object->getCountryCode();



		$s->city = $object->getCity();



		$s->contact_person = $object->getContactPerson();



		$s->email = $object->getEmail();



		$s->phone = $object->getPhone();







		$cords = $object->getGeoCords();



		if (null !== $cords) {



			$s->longitude = $cords->getLongitude();



			$s->latitude = $cords->getLatitude();



		}







		return $s;



	}



}



