<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Settings;







use GuzzleHttp\Psr7\Uri;



use Psr\Http\Message\UriInterface;







final class Settings implements SettingsInterface



{



	public const API_PRODUCTION = 'https://www.apaczka.pl/api/v2/';



	public const SIGN_ALGORITHM = 'sha256';



	public const REQUEST_EXPIRES = 29;



	private const REQUEST_EXPIRES_UNIT = 'min';







	private string $appId;



	private string $appSecret;



	private UriInterface $apiUrl;



	private int $requestExpires;



	private string $signAlgorithm;







	public function __construct(



		string $appId,



		string $appSecret,



		string $apiUrl = self::API_PRODUCTION,



		int $requestExpires = self::REQUEST_EXPIRES,



		string $signAlgorithm = self::SIGN_ALGORITHM



	) {



		$this->appId = $appId;



		$this->appSecret = $appSecret;



		$this->apiUrl = new Uri($apiUrl);



		$this->requestExpires = $requestExpires;



		$this->signAlgorithm = $signAlgorithm;



	}







	public function getApiId(): string



	{



		return $this->appId;



	}







	public function getAppSecret(): string



	{



		return $this->appSecret;



	}







	public function getApiUrl(): UriInterface



	{



		return $this->apiUrl;



	}







	public function getSignAlgorithm(): string



	{



		return $this->signAlgorithm;



	}







	public function getRequestExpires(): int



	{



		return strtotime(



			sprintf('+%d%s', $this->requestExpires, self::REQUEST_EXPIRES_UNIT)



		);



	}



}



