<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Model;







class Shipment



{



	private PackageTypeEnum $packageTypeEnum;



	private float $weight;



	private float $length;



	private float $width;



	private float $height;



	private bool $isOversize;



	private ?string $content;



	private ?string $comment;



	private ?float $weightBillable;



	private ?string $waybillNumber;



	private ?Price $price;







	public function __construct(



		PackageTypeEnum $packageTypeEnum,



		float           $weight,



		float           $length,



		float           $width,



		float           $height,



		bool            $isOversize = false,



		?string         $content = null,



		?string         $comment = null,



		?float          $weightBillable = null,



		?Price $price = null,



		?string         $waybillNumber = null



	) {



		$this->packageTypeEnum = $packageTypeEnum;



		$this->weight = $weight;



		$this->length = $length;



		$this->width = $width;



		$this->height = $height;



		$this->isOversize = $isOversize;



		$this->content = $content;



		$this->comment = $comment;



		$this->weightBillable = $weightBillable;



		$this->waybillNumber = $waybillNumber;



		$this->price = $price;



	}







	public function getPrice(): ?Price



	{



		return $this->price;



	}







	public function getPackageTypeEnum(): PackageTypeEnum



	{



		return $this->packageTypeEnum;



	}







	public function getWeight(): float



	{



		return $this->weight;



	}







	public function getLength(): float



	{



		return $this->length;



	}







	public function getWidth(): float



	{



		return $this->width;



	}







	public function getHeight(): float



	{



		return $this->height;



	}







	public function isOversize(): bool



	{



		return $this->isOversize;



	}







	public function getContent(): ?string



	{



		return $this->content;



	}







	public function getComment(): ?string



	{



		return $this->comment;



	}







	public function getWeightBillable(): ?float



	{



		return $this->weightBillable;



	}







	public function getWaybillNumber(): ?string



	{



		return $this->waybillNumber;



	}



}



