<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Model;







use Apaczka\Api\Client\Common\CollectionInterface;







class ServiceStructure



{



	/**



	 * @var CollectionInterface<UnitType>



	 */



	private CollectionInterface $unitTypeCollection;



	/**



	 * @var CollectionInterface<PickupType>



	 */



	private CollectionInterface $pickupTypeCollection;



	/**



	 * @var CollectionInterface<PointTypeEnum>



	 */



	private CollectionInterface $pointTypeCollection;



	/**



	 * @var CollectionInterface<PackageType>



	 */



	private CollectionInterface $packageTypeCollection;



	/**



	 * @var CollectionInterface<Service>



	 */



	private CollectionInterface $serviceCollection;



	/**



	 * @var CollectionInterface<Option>



	 */



	private CollectionInterface $optionCollection;







	/**



	 * @param CollectionInterface<UnitType> $unitTypeCollection



	 * @param CollectionInterface<PickupType> $pickupTypeCollection



	 * @param CollectionInterface<PointTypeEnum> $pointTypeCollection



	 * @param CollectionInterface<PackageType> $packageTypeCollection



	 * @param CollectionInterface<Service> $serviceCollection



	 * @param CollectionInterface<Option> $optionCollection



	 */



	public function __construct(



		CollectionInterface $unitTypeCollection,



		CollectionInterface $pickupTypeCollection,



		CollectionInterface $pointTypeCollection,



		CollectionInterface $packageTypeCollection,



		CollectionInterface $serviceCollection,



		CollectionInterface $optionCollection



	) {



		$this->unitTypeCollection = $unitTypeCollection;



		$this->pickupTypeCollection = $pickupTypeCollection;



		$this->pointTypeCollection = $pointTypeCollection;



		$this->packageTypeCollection = $packageTypeCollection;



		$this->serviceCollection = $serviceCollection;



		$this->optionCollection = $optionCollection;



	}







	/**



	 * @return CollectionInterface<UnitType>



	 */



	public function getUnitTypes(): CollectionInterface



	{



		return clone $this->unitTypeCollection;



	}







	/**



	 * @return CollectionInterface<PickupType>



	 */



	public function getPickupTypes(): CollectionInterface



	{



		return clone $this->pickupTypeCollection;



	}







	/**



	 * @return CollectionInterface<PointTypeEnum>



	 */



	public function getPointTypes(): CollectionInterface



	{



		return clone $this->pointTypeCollection;



	}







	/**



	 * @return CollectionInterface<PackageType>



	 */



	public function getPackageTypes(): CollectionInterface



	{



		return clone $this->packageTypeCollection;



	}







	/**



	 * @return CollectionInterface<Service>



	 */



	public function getServices(): CollectionInterface



	{



		return clone $this->serviceCollection;



	}







	/**



	 * @return CollectionInterface<Option>



	 */



	public function getOptions(): CollectionInterface



	{



		return clone $this->optionCollection;



	}



}



