<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Model;







class Service



{



	private int $serviceId;



	private ?string $name;



	private ?string $supplier;



	private ?string $deliveryTime;



	private ?bool $isDomestic;



	private ?bool $isPickupCourier;



	private ?bool $isDoorToDoor;



	private ?bool $isDoorToPoint;



	private ?bool $isPointToPoint;



	private ?bool $isPointToDoor;







	public function __construct(



		int $serviceId,



		?string $name = null,



		?string $supplier = null,



		?string $deliveryTime = null,



		?bool $isDomestic = null,



		?bool $isPickupCourier = null,



		?bool $isDoorToDoor = null,



		?bool $isDoorToPoint = null,



		?bool $isPointToPoint = null,



		?bool $isPointToDoor = null



	) {



		$this->serviceId = $serviceId;



		$this->name = $name;



		$this->deliveryTime = $deliveryTime;



		$this->supplier = $supplier;



		$this->isDomestic = $isDomestic;



		$this->isPickupCourier = $isPickupCourier;



		$this->isDoorToDoor = $isDoorToDoor;



		$this->isDoorToPoint = $isDoorToPoint;



		$this->isPointToPoint = $isPointToPoint;



		$this->isPointToDoor = $isPointToDoor;



	}







	public function getServiceId(): int



	{



		return $this->serviceId;



	}







	public function getName(): ?string



	{



		return $this->name;



	}







	public function getDeliveryTime(): ?string



	{



		return $this->deliveryTime;



	}







	public function getSupplier(): ?string



	{



		return $this->supplier;



	}







	public function isDomestic(): ?bool



	{



		return $this->isDomestic;



	}







	public function isPickupCourier(): ?bool



	{



		return $this->isPickupCourier;



	}







	public function isDoorToDoor(): ?bool



	{



		return $this->isDoorToDoor;



	}







	public function isDoorToPoint(): ?bool



	{



		return $this->isDoorToPoint;



	}







	public function isPointToPoint(): ?bool



	{



		return $this->isPointToPoint;



	}







	public function isPointToDoor(): ?bool



	{



		return $this->isPointToDoor;



	}







    public function getDeliveryTypes(): array



    {



        $deliveryTypes = [];







        switch (true) {



            case $this->isDoorToDoor():



                $deliveryTypes[] = 'D2D';



                break;



            case $this->isDoorToPoint():



                $deliveryTypes[] = 'D2P';



                break;



            case $this->isPointToPoint():



                $deliveryTypes[] = 'P2P';



                break;



            case $this->isPointToDoor():



                $deliveryTypes[] = 'P2D';



                break;



        }







        return $deliveryTypes;



    }



}



