<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Model;







use GuzzleHttp\Psr7\Uri;







class Point implements IdInterface



{



	private string $pointId;



	private string $name;



	private Address $address;



	private WeekOpenHours $weekOpenHours;



	private ?int $distance;



	private ?Image $image;



	private ?string $additionalInfo;



	private bool $hasCashOnDeliveryOption;



	private bool $hasSendOption;



	private bool $hasDeliverOption;



	private PointTypeEnum $type;







	public function __construct(



		string $pointId,



		PointTypeEnum $type,



		string $name,



		Address $address,



		WeekOpenHours $weekOpenHours,



		bool $hasCashOnDeliveryOption = false,



		bool $hasSendOption = false,



		bool $hasDeliverOption = false,



		?int $distance = 0,



		?Image $image = null,



		?string $additionalInfo = null



	) {



		$this->pointId = $pointId;



		$this->name = $name;



		$this->address = $address;



		$this->weekOpenHours = $weekOpenHours;



		$this->distance = $distance;



		$this->image = $image;



		$this->additionalInfo = $additionalInfo;



		$this->hasCashOnDeliveryOption = $hasCashOnDeliveryOption;



		$this->hasSendOption = $hasSendOption;



		$this->hasDeliverOption = $hasDeliverOption;



		$this->type = $type;



	}







	public function getType(): PointTypeEnum



	{



		return $this->type;



	}







	public function hasCashOnDeliveryOption(): bool



	{



		return $this->hasCashOnDeliveryOption;



	}







	public function hasSendOption(): bool



	{



		return $this->hasSendOption;



	}







	public function hasDeliverOption(): bool



	{



		return $this->hasDeliverOption;



	}







	public function getId(): ?string



	{



		return $this->pointId;



	}







	public function getName(): string



	{



		return $this->name;



	}







	public function getAddress(): Address



	{



		return $this->address;



	}







	public function getWeekOpenHours(): WeekOpenHours



	{



		return $this->weekOpenHours;



	}







	public function getDistance(): ?int



	{



		return $this->distance;



	}







	public function getImage(): ?Image



	{



		return $this->image;



	}







	public function getAdditionalInfo(): ?string



	{



		return $this->additionalInfo;



	}







    public function __serialize(): array



    {



        return [



            'pointId' => $this->pointId,



            'name' => $this->name,



            'address' => $this->address->__serialize(),



            'weekOpenHours' => $this->weekOpenHours->__serialize(),



            'distance' => $this->distance,



            'additionalInfo' => null === $this->image ? null : $this->image->__serialize(),



            'hasCashOnDeliveryOption' => $this->hasCashOnDeliveryOption,



            'hasSendOption' => $this->hasSendOption,



            'hasDeliverOption' => $this->hasDeliverOption,



            'type' => $this->type->__serialize(),



        ];



    }







    public function __unserialize(array $data): void



    {



        $this->pointId = $data['pointId'] ?? null;



        $this->name = $data['name'] ?? null;



        $this->distance = $data['distance'] ?? null;



        $this->additionalInfo = $data['additionalInfo'] ?? null;



        $this->hasCashOnDeliveryOption = $data['hasCashOnDeliveryOption'] ?? false;



        $this->hasSendOption = $data['hasSendOption'] ?? false;







        $this->image  = null;



        if (isset($data['image']) && null !== $data['image']) {



            $this->image = new Image(new Uri(''));



            $this->image->__unserialize($data['image']);



        }



        $this->weekOpenHours = new WeekOpenHours();



        if (isset($data['weekOpenHours'])) {



            $this->weekOpenHours->__unserialize($data['weekOpenHours']);



        }



        $this->address = new Address();



        if (isset($data['address'])) {



            $this->address->__unserialize($data['address']);



        }



        $this->type = new PointTypeEnum(PointTypeEnum::INPOST);



        if (isset($data['type'])) {



            $this->type->__unserialize($data['type']);



        }



    }







}



