<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Model;







use Apaczka\Api\Client\Common\CollectionInterface;



use DateTimeImmutable;



use Psr\Http\Message\UriInterface;







class Order implements IdInterface



{



	private ?string $orderId;



	private ?Service $service;



	private ?Address $sender;



	private ?Address $receiver;



	private OrderStatusEnum $status;



	/**



	 * @var ?CollectionInterface<Shipment>



	 */



	private ?CollectionInterface $shipmentCollection;



	private ?string $content;



	private ?string $comment;



	private ?string $waybillNumber;



	private ?Pickup $pickup;



	private ?UriInterface $trackingUrl;



	private ?DateTimeImmutable $created;



	private ?DateTimeImmutable $delivered;



	private bool $cashOnDelivery;



	private bool $declarationValue;



	private Price $price;



    private ?int $cashOnDeliveryAmount;



    private ?string $bankAccountNumber;







    /**



	 * @param ?CollectionInterface<Shipment> $shipmentCollection



	 */



	public function __construct(



		?string $orderId,



		?Service $service,



		?Address $sender,



		?Address $receiver,



		OrderStatusEnum $status,



		?CollectionInterface $shipmentCollection,



		Price $price,



		?string $content = null,



		?string $comment = null,



		?string $waybillNumber = null,



		?Pickup $pickup = null,



		?UriInterface $trackingUrl = null,



		?DateTimeImmutable $created = null,



		?DateTimeImmutable $delivered = null,



		bool $cashOnDelivery = false,



        ?int $cashOnDeliverAmount = null,



        ?string $bankAccountNumber = null,



		bool $declarationValue = false



	) {



		$this->orderId = $orderId;



		$this->service = $service;



		$this->sender = $sender;



		$this->receiver = $receiver;



		$this->status = $status;



		$this->shipmentCollection = $shipmentCollection;



		$this->content = $content;



		$this->comment = $comment;



		$this->waybillNumber = $waybillNumber;



		$this->pickup = $pickup;



		$this->trackingUrl = $trackingUrl;



		$this->created = $created;



		$this->delivered = $delivered;



		$this->cashOnDelivery = $cashOnDelivery;



		$this->declarationValue = $declarationValue;



		$this->price = $price;



        $this->cashOnDeliveryAmount = $cashOnDeliverAmount;



        $this->bankAccountNumber = $bankAccountNumber;



	}







	public function getPrice(): Price



	{



		return $this->price;



	}







	public function getId(): ?string



	{



		return $this->orderId;



	}







	public function getService(): ?Service



	{



		return $this->service;



	}







	public function getSender(): ?Address



	{



		return $this->sender;



	}







	public function getReceiver(): ?Address



	{



		return $this->receiver;



	}







	public function getStatus(): OrderStatusEnum



	{



		return $this->status;



	}







	/**



	 * @return ?CollectionInterface<Shipment>



	 */



	public function getShipmentCollection(): ?CollectionInterface



	{



		return $this->shipmentCollection;



	}







	public function getContent(): ?string



	{



		return $this->content;



	}







	public function getComment(): ?string



	{



		return $this->comment;



	}







	public function getWaybillNumber(): ?string



	{



		return $this->waybillNumber;



	}







	public function getPickup(): ?Pickup



	{



		return $this->pickup;



	}







	public function getTrackingUrl(): ?UriInterface



	{



		return $this->trackingUrl;



	}







	public function getCreated(): ?DateTimeImmutable



	{



		return $this->created;



	}







	public function getDelivered(): ?DateTimeImmutable



	{



		return $this->delivered;



	}







	public function isCashOnDelivery(): bool



	{



		return $this->cashOnDelivery;



	}







	public function isDeclarationValue(): bool



	{



		return $this->declarationValue;



	}







    public function unsetService(): void{



        $this->service = null;



    }







    public function getCashOnDeliveryAmount(): ?int



    {



        return $this->cashOnDeliveryAmount;



    }







    public function getBankAccountNumber(): ?string



    {



        return $this->bankAccountNumber;



    }







}



