<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Model;







class Address implements IdInterface



{



	private ?string $countryCode;



	private ?string $name;



	private ?string $line1;



	private ?string $line2;



	private ?string $postalCode;



	private ?string $city;



	private ?bool $isResidential;



	private ?string $contactPerson;



	private ?string $email;



	private ?string $phone;



	private ?string $foreignAddressId;



	private ?GeoCords $geoCords;







	public function __construct(



		?string $countryCode = null,



		?string $name = null,



		?string $line1 = null,



		?string $line2 = null,



		?string $postalCode = null,



		?string $city = null,



		?GeoCords $geoCords = null,



		?bool $isResidential = false,



		?string $contactPerson = null,



		?string $email = null,



		?string $phone = null,



		?string $foreignAddressId = null



	) {



		$this->countryCode = $countryCode;



		$this->name = $name;



		$this->line1 = $line1;



		$this->line2 = $line2;



		$this->postalCode = $postalCode;



		$this->city = $city;



		$this->isResidential = $isResidential;



		$this->contactPerson = $contactPerson;



		$this->email = $email;



		$this->phone = $phone;



		$this->foreignAddressId = $foreignAddressId;



		$this->geoCords = $geoCords;



	}







	public function getId(): ?string



	{



		return (string) $this->getForeignAddressId();



	}







	public function getGeoCords(): ?GeoCords



	{



		return $this->geoCords;



	}







	public function getCountryCode(): ?string



	{



		return $this->countryCode;



	}







	public function getName(): ?string



	{



		return $this->name;



	}







	public function getLine1(): ?string



	{



		return $this->line1;



	}







	public function getLine2(): ?string



	{



		return $this->line2;



	}







	public function getPostalCode(): ?string



	{



		return $this->postalCode;



	}







	public function getCity(): ?string



	{



		return $this->city;



	}







	public function getIsResidential(): ?bool



	{



		return $this->isResidential;



	}







	public function getContactPerson(): ?string



	{



		return $this->contactPerson;



	}







	public function getEmail(): ?string



	{



		return $this->email;



	}







	public function getPhone(): ?string



	{



		return $this->phone;



	}







	public function getForeignAddressId(): ?string



	{



		return $this->foreignAddressId;



	}







    public function __serialize(): array



    {



        return [



            'countryCode' => $this->countryCode,



            'name' => $this->name,



            'line1' => $this->line1,



            'line2' => $this->line2,



            'postalCode' => $this->postalCode,



            'city' => $this->city,



            'isResidential' => $this->isResidential,



            'contactPerson' => $this->contactPerson,



            'email' => $this->email,



            'phone' => $this->phone,



            'foreignAddressId' => $this->foreignAddressId,



            'geoCords' => null === $this->geoCords ? null : $this->geoCords->__serialize(),



        ];



    }







    public function __unserialize(array $data): void



    {



        $i = 0;



        $this->countryCode = $data['countryCode'] ?? $data[$i++] ?? null;



        $this->name = $data['name'] ?? $data[$i++] ?? null;



        $this->line1 = $data['line1'] ?? $data[$i++] ?? null;



        $this->line2 = $data['line2'] ?? $data[$i++] ?? null;



        $this->postalCode = $data['postalCode'] ?? $data[$i++] ?? null;



        $this->city = $data['city'] ?? $data[$i++] ?? null;



        $this->isResidential = $data['isResidential'] ?? $data[$i++] ?? null;



        $this->contactPerson = $data['contactPerson'] ?? $data[$i++] ?? null;



        $this->phone = $data['phone'] ?? $data[$i++] ?? null;



        $this->foreignAddressId = $data['foreignAddressId'] ?? $data[$i++] ?? null;







        if (isset($data['geoCords']) && null !== $data['geoCords']) {



            $this->geoCords = new GeoCords(0.0, 0.0);



            $this->geoCords->__unserialize($data['geoCords']);



        }



    }



}



