<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Http\Processor;







use Apaczka\Api\Client\Http\Exception\HttpBadRequestException;



use GuzzleHttp\ClientInterface;



use Psr\Http\Message\RequestInterface;



use Psr\Http\Message\ResponseInterface;







class RequestProcessorGuzzleV7 implements RequestProcessorInterface



{



	private ClientInterface $client;







	public function __construct(ClientInterface $client)



	{



		$this->client = $client;



	}







	public function process(RequestInterface $request, int $successCode = 200): ResponseInterface



	{



		try {



			return $this->client->send($request, ['verify' => false]);



		} catch (GuzzleException $e) {



			throw new HttpBadRequestException($e->getMessage(), $e->getCode());



		}



	}



}



