<?php







namespace Apaczka\Api\Client\Http\Plugin;







use Apaczka\Api\Client\Settings\SettingsInterface;



use Psr\Http\Message\RequestInterface;



use Psr\Http\Message\ResponseInterface;



use Psr\Http\Message\StreamFactoryInterface;



use Psr\Http\Message\StreamInterface;







class SingRequestPlugin implements PluginInterface



{



	private SettingsInterface $settings;



	private StreamFactoryInterface $streamFactory;







	public function __construct(



		SettingsInterface $settings,



		StreamFactoryInterface $streamFactory



	) {



		$this->settings = $settings;



		$this->streamFactory = $streamFactory;



	}







	public function handleRequest(RequestInterface $request): RequestInterface



	{



		$content = $request->getBody()->getContents();



		$route = str_replace($this->settings->getApiUrl(), '', (string) $request->getUri());



		$dataToSign = sprintf("%s:%s:%s:%s", $this->settings->getApiId(), $route, $content, $this->settings->getRequestExpires());







        $payload = [



            'app_id' => $this->settings->getApiId(),



            'expires' => $this->settings->getRequestExpires(),



            'request' => $content,



            'signature' => $this->sing($dataToSign)



        ];







		$request = $request->withBody(



			$this->createStream($payload)



		);







		$request->getBody()->rewind();







		return $request;



	}







	private function sing(string $data): string



	{



		return hash_hmac($this->settings->getSignAlgorithm(), $data, $this->settings->getAppSecret());



	}







	/**



	 * @param array<string, string|int|float|null> $data



	 */



	private function createStream(array $data): StreamInterface



	{



		return $this->streamFactory->createStream(http_build_query($data));



	}







	public function handleResponse(RequestInterface $request, ResponseInterface $response): ResponseInterface



	{



		return $response;



	}



}



