<?php



namespace GuzzleHttp\Ring\Client;







/**



 * Client specific utility functions.



 */



class ClientUtils



{



    /**



     * Returns the default cacert bundle for the current system.



     *



     * First, the openssl.cafile and curl.cainfo php.ini settings are checked.



     * If those settings are not configured, then the common locations for



     * bundles found on Red Hat, CentOS, Fedora, Ubuntu, Debian, FreeBSD, OS X



     * and Windows are checked. If any of these file locations are found on



     * disk, they will be utilized.



     *



     * Note: the result of this function is cached for subsequent calls.



     *



     * @return string



     * @throws \RuntimeException if no bundle can be found.



     */



    public static function getDefaultCaBundle()



    {



        static $cached = null;



        static $cafiles = [



            // Red Hat, CentOS, Fedora (provided by the ca-certificates package)



            '/etc/pki/tls/certs/ca-bundle.crt',



            // Ubuntu, Debian (provided by the ca-certificates package)



            '/etc/ssl/certs/ca-certificates.crt',



            // FreeBSD (provided by the ca_root_nss package)



            '/usr/local/share/certs/ca-root-nss.crt',



            // OS X provided by homebrew (using the default path)



            '/usr/local/etc/openssl/cert.pem',



            // Windows?



            'C:\\windows\\system32\\curl-ca-bundle.crt',



            'C:\\windows\\curl-ca-bundle.crt',



        ];







        if ($cached) {



            return $cached;



        }







        if ($ca = ini_get('openssl.cafile')) {



            return $cached = $ca;



        }







        if ($ca = ini_get('curl.cainfo')) {



            return $cached = $ca;



        }







        foreach ($cafiles as $filename) {



            if (file_exists($filename)) {



                return $cached = $filename;



            }



        }







        throw new \RuntimeException(self::CA_ERR);



    }







    const CA_ERR = "



No system CA bundle could be found in any of the the common system locations.



PHP versions earlier than 5.6 are not properly configured to use the system's



CA bundle by default. In order to verify peer certificates, you will need to



supply the path on disk to a certificate bundle to the 'verify' request



option: http://docs.guzzlephp.org/en/5.3/clients.html#verify. If you do not



need a specific certificate bundle, then Mozilla provides a commonly used CA



bundle which can be downloaded here (provided by the maintainer of cURL):



https://raw.githubusercontent.com/bagder/ca-bundle/master/ca-bundle.crt. Once



you have a CA bundle available on disk, you can set the 'openssl.cafile' PHP



ini setting to point to the path to the file, allowing you to omit the 'verify'



request option. See http://curl.haxx.se/docs/sslcerts.html for more



information.";



}



