<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Repository\InConfiguration;





use Apaczka\Api\Client\Model\PointsCollection;


use Apaczka\Api\Client\Model\PointTypeEnum;


use Apaczka\Prestashop\Model\PointsRepositoryInterface;


use Apaczka\Prestashop\Provider\ApiClientProvider;


use DateInterval;


use DateTimeImmutable;


use PrestaShop\PrestaShop\Adapter\Configuration;





class PointsRepository implements PointsRepositoryInterface


{


    private const CONFIGURATION_LIST_PATTERN = 'APACZKA_SUPPLIER_%s_POINTS';


    private const CONFIGURATION_EXPIRE_PATTERN = 'APACZKA_SUPPLIER_%s_EXPIRE';


    private const EXPIRE_INTERVAL = 'PT24H';





    private Configuration $configuration;


    private ApiClientProvider $apiClientProvider;





    public function __construct(


        Configuration $configuration,


        ApiClientProvider $apiClientProvider)


    {


        $this->configuration = $configuration;


        $this->apiClientProvider = $apiClientProvider;


    }





    public function filter(PointTypeEnum $typeEnum): PointsCollection


    {


        $expireKey = $this->getExpireKey($typeEnum);


        $listKey = $this->getListKey($typeEnum);


        $now = new DateTimeImmutable();





        if ($this->configuration->has($expireKey)) {


            $expire = unserialize($this->configuration->get($expireKey));


            if ($now > $expire && $this->configuration->has($listKey)) {





                return unserialize($this->configuration->get($listKey));


            }


        }





        $list = $this->apiClientProvider->getClient()->getPoints($typeEnum);


        $this->configuration->set($listKey, serialize($list));


        $expire = $now->add(new DateInterval(self::EXPIRE_INTERVAL));


        $this->configuration->set($expireKey, serialize($expire));





        return $list;


    }





    public function get(PointTypeEnum $typeEnum, string $identity): ?PointTypeEnum


    {


        $points = $this->filter($typeEnum);





        foreach($points as $point) {


            if ($point->getId() === $identity) {


                return $point;


            }


        }





        return null;


    }





    private function getListKey(PointTypeEnum $typeEnum): string


    {


        return $this->buildKey($typeEnum, self::CONFIGURATION_LIST_PATTERN);


    }





    private function getExpireKey(PointTypeEnum $typeEnum): string


    {


        return $this->buildKey($typeEnum, self::CONFIGURATION_EXPIRE_PATTERN);


    }





    private function buildKey( PointTypeEnum $typeEnum, string $pattern): string


    {


        return sprintf($pattern, (string) $typeEnum);


    }


}