<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Repository\InConfiguration;





use Apaczka\Prestashop\Model\PickupHours;


use Apaczka\Prestashop\Model\PickupHoursRepositoryInterface;


use PrestaShop\PrestaShop\Adapter\Configuration;





class PickupHoursRepository implements PickupHoursRepositoryInterface


{


    private const CONFIGURATION_KEY = 'APACZKA_SETTINGS_PICKUP_HOURS';





    private Configuration $configuration;





    public function __construct(Configuration $configuration)


    {


        $this->configuration = $configuration;


    }





    public function save(PickupHours $hours): void


    {


        $this->configuration->set(self::CONFIGURATION_KEY, serialize($hours));


    }





    public function get(): ?PickupHours


    {


        if (!$this->configuration->has(self::CONFIGURATION_KEY)) {


            return null;


        }





        return unserialize($this->configuration->get(self::CONFIGURATION_KEY));


    }


}