<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Repository\InConfiguration;





use Apaczka\Prestashop\Model\ApiAccess;


use Apaczka\Prestashop\Model\ApiAccessRepositoryInterface;


use PrestaShop\PrestaShop\Adapter\Configuration;





class ApiAccessRepository implements ApiAccessRepositoryInterface


{


    private const CONFIGURATION_KEY = 'APACZKA_SETTIINGS_CONFIGURATION';





    private Configuration $configuration;





    public function __construct(Configuration $configuration)


    {


        $this->configuration = $configuration;


    }





    public function load(): ?ApiAccess


    {


        if (!$this->configuration->has(self::CONFIGURATION_KEY)) {


            return null;


        }





        $data = unserialize($this->configuration->get(self::CONFIGURATION_KEY));


        if (!is_array($data) || !isset($data['id']) || !isset($data['secret']) || empty($data['id']) || empty($data['secret'])) {


            return null;


        }





        return ApiAccess::restore($data['id'], $data['secret']);


    }





    public function save(ApiAccess $apiAccess): void


    {


        $data = [


            'id' => $apiAccess->getApiId(),


            'secret' => $apiAccess->getApiSecret()


        ];





        $this->remove();


        $this->configuration->set(self::CONFIGURATION_KEY, serialize($data));


    }





    public function remove(): void


    {


        if (!$this->configuration->has(self::CONFIGURATION_KEY)) {


            return;


        }





        $this->configuration->remove(self::CONFIGURATION_KEY);


    }





}