<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Repository\Doctrine;





use Apaczka\Prestashop\Entity\ApaczkaSender;


use Apaczka\Prestashop\Model\SenderRepositoryInterface;


use Doctrine\ORM\EntityRepository;





class SenderRepository extends EntityRepository implements SenderRepositoryInterface


{


    public function get(int $id): ?ApaczkaSender


    {


        return $this->find($id);


    }





    public function getDefault(): ?ApaczkaSender


    {


        return $this->createQueryBuilder('s')


            ->where('s.isDefault = true')


            ->getQuery()


            ->getOneOrNullResult();


    }





    public function add(ApaczkaSender $sender): void


    {


        if ($sender->isDefault()) {


            $this->unsetDefaultSender();


        }


        $this->getEntityManager()->persist($sender);


        $this->getEntityManager()->flush();


    }





    public function remove(ApaczkaSender $sender): void


    {


        $this->getEntityManager()->remove($sender);


        $this->getEntityManager()->flush();


    }





    public function list(array $filters = [], array $orders = ['templateName' => 'asc']): iterable


    {


        return $this->findBy($filters, $orders);


    }





    public function count(array $filters = []): int


    {


        return parent::count($filters);


    }





    private function unsetDefaultSender(): void


    {


        $this->createQueryBuilder('s')


            ->set('s.isDefault', false)


            ->where('s.isDefault = true')


            ->getQuery()


            ->execute();


    }





}