<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Repository\Doctrine;





use Apaczka\Prestashop\Entity\ApaczkaPackage;


use Apaczka\Prestashop\Model\PackageRepositoryInterface;


use Apaczka\Prestashop\Provider\PackageTypesProvider;


use Doctrine\ORM\EntityRepository;





class PackageRepository extends EntityRepository implements PackageRepositoryInterface


{


    private PackageTypesProvider $packageTypesProvider;





    public function setPackageTypesProvider(PackageTypesProvider $packageTypesProvider): void


    {


        $this->packageTypesProvider = $packageTypesProvider;


    }





    public function get(int $id): ?ApaczkaPackage


    {


        return $this->find($id);


    }





    public function getDefault(): ?ApaczkaPackage


    {


        return $this->createQueryBuilder('p')


            ->where('p.isDefault = true')


            ->getQuery()


            ->getOneOrNullResult();


    }





    public function add(ApaczkaPackage $package): void


    {


        if ($package->isDefault()) {


            $this->unsetDefaultPackage();


        }





        $this->getEntityManager()->persist($package);


        $this->getEntityManager()->flush();


    }





    public function remove(ApaczkaPackage $package): void


    {


        $this->getEntityManager()->remove($package);


        $this->getEntityManager()->flush();


    }





    public function list(array $filters = [], array $orders = ['templateName' => 'asc']): iterable


    {


        return $this->findBy($filters, $orders);


    }





    public function count(array $filters = []): int


    {


        return parent::count($filters);


    }





    public function getTypeOptions(): array


    {


        if (!isset($this->packageTypesProvider)) {


            throw new \RuntimeException('PackageTypesProvider is not set. Do you forgot to call "setPackageTypesProvider" method?');


        }





        return $this->packageTypesProvider->getOptions();


    }





    private function unsetDefaultPackage(): void


    {


        $this->createQueryBuilder('p')


            ->set('p.isDefault', false)


            ->where('p.isDefault = true')





            ->getQuery()


            ->execute();


    }


}