<?php





declare(strict_types=1);








namespace Apaczka\Prestashop\Repository\Doctrine;





use Apaczka\Prestashop\Entity\ApaczkaOrder;


use Apaczka\Prestashop\Model\OrderRepositoryInterface;


use Doctrine\ORM\EntityRepository;





class OrderRepository extends EntityRepository implements OrderRepositoryInterface


{


    public function getByPsOrderId(int $psOrderId): ?ApaczkaOrder


    {


        return $this->findOneBy(['psOrderId' => $psOrderId]);


    }





    public function remove(ApaczkaOrder $order): void


    {


        $this->getEntityManager()->remove($order);


        $this->getEntityManager()->flush();


    }





    public function add(ApaczkaOrder $order): void


    {


        $this->getEntityManager()->persist($order);


        $this->getEntityManager()->flush();


    }


}