<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Provider;





use Apaczka\Api\Client\Model\Service;





class DeliveryServicesProvider


{


    private ApiClientProvider $apiClientProvider;





    public function  __construct(ApiClientProvider $apiClientProvider)


    {


        $this->apiClientProvider = $apiClientProvider;


    }





    /**


     * @return array<int, string>


     */


    public function getOptions(): array


    {


        $services = $this->apiClientProvider->getClient()->getServiceStructure()->getServices();


        $options = [];





        /**


         * @var Service $service


         */


        foreach ($services as $service) {


            $options[$service->getServiceId()] = $service->getName();





            $deliveryTypes = $service->getDeliveryTypes();





            if (0 < count($deliveryTypes)) {


                $options[$service->getServiceId()] .=  sprintf(" (%s)", implode(', ', $deliveryTypes));


            }


        }





        asort($options);





        return $options;


    }


}