<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Helper;





use OrderCore as PrestaShopOrder;





final class CodHelper


{


    private const PS_CASH_ON_DELIVERY_MODULE = 'ps_cashondelivery';





    private const COD_MODULES = [


       self::PS_CASH_ON_DELIVERY_MODULE


    ];





    public function isCod(PrestaShopOrder $order): bool


    {


        return in_array($order->module, self::COD_MODULES,  true);


    }





    public function getAmount(PrestaShopOrder $order): ?float


    {


        if (!$this->isCod($order)) {


            return null;


        }





        return round((float) $order->total_paid_tax_incl, 2);


    }


}