<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Form\Admin;





use Apaczka\Prestashop\Model\PickupHours;


use Apaczka\Prestashop\Model\SendingPoint;


use Symfony\Component\Form\AbstractType;


use Symfony\Component\Form\FormBuilderInterface;


use Symfony\Component\Form\FormError;


use Symfony\Component\OptionsResolver\OptionsResolver;


use Symfony\Component\Form\Extension\Core\Type as FormFieldType;


use Symfony\Component\Form\FormEvent;


use Symfony\Component\Form\FormEvents;





class SettingsPickupHoursForm extends AbstractType


{


    private const TRANSLATION_DOMAIN = 'Modules.Apaczkashipments.Admin';





    public function buildForm(FormBuilderInterface $builder, array $options)


    {


        $hours = [];


        for ($i = 8; $i <= 18; $i++) {


            $h = $i < 10 ? 0 . $i : $i;


            $hours[$h . ':00'] = $h . ':00';


            if ($i < 18) {


                $hours[$h . ':30'] = $h . ':30';


            }


        }





        $builder


            ->add(


                'from',


               FormFieldType\ChoiceType::class,


                [


                    'choices' => $hours,


                    'required' => false,


                    'label' => 'settings.pickup.hour_from.label',


                    'placeholder' =>'settings.pickup.hour_from.placeholder',


                    'translation_domain' => self::TRANSLATION_DOMAIN,


                    'multiple' => false,


                    'expanded' => false,


                ]


            )


            ->add(


                'to',


                FormFieldType\ChoiceType::class,


                [


                    'choices' => $hours,


                    'required' => false,


                    'label' => 'settings.pickup.to_from.label',


                    'placeholder' =>'settings.pickup.hour_to.placeholder',


                    'translation_domain' => self::TRANSLATION_DOMAIN,


                    'multiple' => false,


                    'expanded' => false,


                ]


            );





        $builder->addEventListener(


            FormEvents::POST_SUBMIT,


            function (FormEvent $event) {


                $form = $event->getForm();


                $data = $event->getData();





                $from = $data->getFrom();


                $to = $data->getTo();





                if ($from === null && $to === null) {


                    return;


                }





                [$fh, $fm] = explode(':', $from);


                [$th, $tm] = explode(':', $to);





                $timeFromInMinutes = (int) $fh * 60 + (int) $fm;


                $timeToInMinutes = (int) $th * 60 + (int) $tm;





                if ($timeFromInMinutes >= $timeToInMinutes || $timeToInMinutes - $timeFromInMinutes < 120) {


                    $form->get('to')->addError(new FormError(


                        'settings.pickup.hour_to.to_small_period'


                    ));


                }


            }


        );


    }





    public function configureOptions(OptionsResolver $resolver)


    {


        $resolver->setDefaults([


            'data_class' => PickupHours::class


        ]);


    }


}