<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Form\Admin;





use Symfony\Component\Form\AbstractType;


use Symfony\Component\Form\FormBuilderInterface;


use Symfony\Component\Form\Extension\Core\Type as FormFieldType;


use Symfony\Component\OptionsResolver\OptionsResolver;


use Symfony\Component\Validator\Constraints as Assert;





class SettingsForm extends AbstractType


{


    private const TRANSLATION_DOMAIN = 'Modules.Apaczkashipments.Admin';





    public function buildForm(FormBuilderInterface $builder, array $options)


    {


        $builder


            ->add('sender', SenderForm::class)


            ->add('services', FormFieldType\ChoiceType::class, [


                'choices' => $options['servicesChoices'],


                'multiple' => true,


                'expanded' => true,


                'label' => false,


                'required' => true,


                'constraints' => [


                    new Assert\Count(['min' => 1]),


                ]


            ])


            ->add(


                'package',


                PackageForm::class,


                [


                    'label' => false,


                    'servicesChoices' => $options['servicesChosenChoices'],


                    'typesChoices' => $options['packageTypesChoices'],


                ])





            ->add(


                'points',


                SettingsSendingPointsForm::class,


                [


                    'label' => false,


                ]


            )


            ->add(


                'pickup_hours',


                SettingsPickupHoursForm::class,


                [


                    'label' => false,


                ]


            );


    }





    public function configureOptions(OptionsResolver $resolver)


    {


        $resolver->setDefaults([]);





        $resolver->setRequired([


            'servicesChoices',


            'servicesChosenChoices',


            'packageTypesChoices',


        ]);


        $resolver->setAllowedTypes('servicesChoices', 'array');


        $resolver->setAllowedTypes('servicesChosenChoices', 'array');


        $resolver->setAllowedTypes('packageTypesChoices', 'array');


    }


}