<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Form\Admin;





use Symfony\Component\Form\AbstractType;


use Symfony\Component\Form\FormBuilderInterface;


use Symfony\Component\Form\Extension\Core\Type as FormFieldType;


use Symfony\Component\Validator\Constraints as Assert;





class SettingsApiAccessForm extends AbstractType


{


    private const TRANSLATION_DOMAIN = 'Modules.Apaczkashipments.Admin';





    public function buildForm(FormBuilderInterface $builder, array $options)


    {


        $builder->add('api_id', FormFieldType\TextType::class, [


            'label' => 'settings.api_access.form.api_id.label',


            'translation_domain' => self::TRANSLATION_DOMAIN,


            'required' => true,


            'attr' => [


                'minlength' => 36,


                'maxlength' => 36


            ],


            'constraints' => [


                new Assert\NotBlank(),


            ],


        ]);





        $builder->add('api_secret', FormFieldType\TextType::class, [


            'label' => 'settings.api_access.form.api_secret.label',


            'translation_domain' => self::TRANSLATION_DOMAIN,


            'required' => true,


            'attr' => [


                'minlength' => 36,


                'maxlength' => 36


            ],


            'constraints' => [


                new Assert\NotBlank(),


            ],


        ]);


    }


}