<?php





declare(strict_types=1);








namespace Apaczka\Prestashop\Form\Admin;





use Apaczka\Prestashop\Entity\ApaczkaSender;


use Symfony\Component\Form\AbstractType;


use Symfony\Component\Form\FormBuilderInterface;


use Symfony\Component\Form\Extension\Core\Type as FormFieldType;


use Symfony\Component\OptionsResolver\OptionsResolver;


use Symfony\Component\Validator\Constraints as Assert;





class SenderForm extends AbstractType


{


    private const TRANSLATION_DOMAIN = 'Modules.Apaczkashipments.Admin';





    public function buildForm(FormBuilderInterface $builder, array $options)


    {


        $builder->add('companyName', FormFieldType\TextType::class, [


            'label' => 'company.label',


            'required' => false,


            'translation_domain' => self::TRANSLATION_DOMAIN,


            'attr' => [


                'maxlength' => 50


            ],


            'constraints' => [


                new Assert\Length(['max' => 50]),


            ],


            ])


            ->add('firstname', FormFieldType\TextType::class, [


                'label' => 'firstname.label',


                'translation_domain' => self::TRANSLATION_DOMAIN,


                'required' => true,


                'attr' => [


                    'maxlength' => 50


                ],


                'constraints' => [


                    new Assert\NotBlank(),


                    new Assert\Length(['max' => 50]),


                ],


            ])


            ->add('lastname', FormFieldType\TextType::class, [


                'label' => 'lastname.label',


                'required' => true,


                'translation_domain' => self::TRANSLATION_DOMAIN,


                'attr' => [


                    'maxlength' => 50


                ],


                'constraints' => [


                    new Assert\NotBlank(),


                    new Assert\Length(['max' => 50]),


                ],


            ])


            ->add('street', FormFieldType\TextType::class, [


                'required' => true,


                'label' => 'street.label',


                'translation_domain' => self::TRANSLATION_DOMAIN,


                'attr' => [


                    'maxlength' => 50


                ],


                'constraints' => [


                    new Assert\NotBlank(),


                    new Assert\Length(['max' => 50]),


                ],


            ])


            ->add('homeNumber', FormFieldType\TextType::class, [


                'required' => true,


                'label' => 'home_number.label',


                'translation_domain' => self::TRANSLATION_DOMAIN,


                'attr' => [


                    'maxlength' => 10


                ],


                'constraints' => [


                    new Assert\NotBlank(),


                    new Assert\Length(['max' => 10]),


                ],


            ])


            ->add('flatNumber', FormFieldType\TextType::class, [


                'required' => false,


                'label' => 'flat_number.label',


                'translation_domain' => self::TRANSLATION_DOMAIN,


                'attr' => [


                    'maxlength' => 10


                ],


                'constraints' => [


                    new Assert\Length(['max' => 10]),


                ],


            ])


            ->add('postCode', FormFieldType\TextType::class, [


                'required' => true,


                'label' => 'post_code.label',


                'translation_domain' => self::TRANSLATION_DOMAIN,


                'attr' => [


                    'maxlength' => 6,


                    'placeholder' => 'XX-YYY'


                ],


                'constraints' => [


                    new Assert\NotBlank(),


                    new Assert\Regex(['pattern' => '/\d\d\-\d\d\d/']),


                ],


            ])


            ->add('city', FormFieldType\TextType::class, [


                'required' => true,


                'label' => 'city.label',


                'translation_domain' => self::TRANSLATION_DOMAIN,


                'attr' => [


                    'maxlength' => 50


                ],


                'constraints' => [


                    new Assert\NotBlank(),


                    new Assert\Length(['max' => 50]),


                ],


            ])


            ->add('contactPerson', FormFieldType\TextType::class, [


                'label' => 'contactPerson.label',


                'required' => true,


                'translation_domain' => self::TRANSLATION_DOMAIN,


                'attr' => [


                    'maxlength' => 50


                ],


                'constraints' => [


                    new Assert\NotBlank(),


                    new Assert\Length(['max' => 50]),


                ],


            ])


            ->add('phoneNumber', FormFieldType\TextType::class, [


                'label' => 'phone_number.label',


                'translation_domain' => self::TRANSLATION_DOMAIN,


                'required' => true,


                'attr' => [


                    'maxlength' => 9,


                    'placeholder' => 'XXXXXXXXX'


                ],


                'constraints' => [


                    new Assert\NotBlank(),


                    new Assert\Length(['min' => 9, 'max' => 9]),


                ],


            ])


            ->add('email', FormFieldType\TextType::class, [


                'required' => true,


                'label' => 'email.label',


                'translation_domain' => self::TRANSLATION_DOMAIN,


                'attr' => [


                    'maxlength' => 255,


                    'placeholder' => 'mail@example.com'


                ],


                'constraints' => [


                    new Assert\NotBlank(),


                    new Assert\Email(['checkMX' => false]),


                    new Assert\Length(['max' => 255]),


                ],


            ])


            ->add('accountNumber', FormFieldType\TextType::class, [


                'required' => true,


                'label' => 'account_number.label',


                'translation_domain' => self::TRANSLATION_DOMAIN,


                'attr' => [


                    'maxlength' => 35,


                    'placeholder' => 'PL ZZ XXXX YYYY XXXX YYYY XXXX YYYY'


                ],


                'constraints' => [


                    new Assert\NotBlank(),


                    new Assert\Iban(),


                    new Assert\Length(['max' => 35]),


                ],


            ]);





            if ($options['addTemplateName']) {


                $builder->


                add("templateName", FormFieldType\TextType::class, [


                    'required' => false,


                    'label' => false,


                    'attr' => [


                        'maxlength' => 50,


                        'class' => 'apaczka-template-sender-name'


                    ]


                ]);


            }


    }





    public function configureOptions(OptionsResolver $resolver)


    {


        $resolver->setDefaults([


            'data_class' => ApaczkaSender::class,


            'addTemplateName' => true,


        ]);








        $resolver->setAllowedTypes('addTemplateName', 'bool');


    }


}