<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Form\Admin;





use Symfony\Component\Form\AbstractType;


use Symfony\Component\Form\FormBuilderInterface;


use Symfony\Component\Form\Extension\Core\Type as FormFieldType;


use Symfony\Component\OptionsResolver\OptionsResolver;


use Symfony\Component\Validator\Constraints as Assert;





class OrderForm extends AbstractType


{


    private const TRANSLATION_DOMAIN = 'Modules.Apaczkashipments.Admin';





    public function buildForm(FormBuilderInterface $builder, array $options)


    {


        $builder


            ->add('senders',


                FormFieldType\ChoiceType::class, [


                'choices' => $options['sendersChoices'],


                'label' => 'choose.sender.template.label',


                'translation_domain' => self::TRANSLATION_DOMAIN,


                'multiple' => false,


                'expanded' => false,


                'required' => false,


                    'attr' => ['class' => 'apaczka-order-switch-senders']


            ])


            ->add(


                'sender',


                SenderForm::class,


                [


                   'label' => false,


                    'addTemplateName' => false,


                ]


            )


            ->add(


                'recipient',


                RecipientForm::class,


                [


                    'label' => false,


                ]


            )


            ->add('packages',


                FormFieldType\ChoiceType::class, [


                    'choices' => $options['packagesChoices'],


                    'label' => 'choose.package.template.label',


                    'translation_domain' => self::TRANSLATION_DOMAIN,


                    'multiple' => false,


                    'expanded' => false,


                    'required' => false,


                    'attr' => ['class' => 'apaczka-order-switch-packages'],


            ])


            ->add(


                'package',


                PackageForm::class,


                [


                    'label' => false,


                    'disableSwitchService' => true,


                    'typesChoices' => $options['typesChoices'],


                    'servicesChoices' => $options['servicesChoices'],


                    'addTemplateName' => false,


                    'requireContent' => true,


                ]


            )


            ->add('cashOnDelivery', FormFieldType\MoneyType::class, [


                'required' => false,


                'label' => 'package.cash_on_delivery.label',


                'translation_domain' => self::TRANSLATION_DOMAIN,


                'currency' => 'PLN',


                'scale' => 2,


                'attr' => [


                    'maxlength' => 5,


                ],


                'constraints' => [


                    new Assert\GreaterThanOrEqual([


                        'value' => 0,


                    ]),


                    new Assert\LessThanOrEqual([


                        'value' => 20000,


                    ]),


                ]


            ])


            ->add('shipmentValue', FormFieldType\MoneyType::class, [


                'required' => false,


                'label' => 'package.shipment_value.label',


                'translation_domain' => self::TRANSLATION_DOMAIN,


                'currency' => 'PLN',


                'scale' => 2,


                'attr' => [


                    'maxlength' => 6,


                ],


                'constraints' => [


                    new Assert\GreaterThanOrEqual([


                        'value' => 0,


                    ]),


                    new Assert\LessThanOrEqual([


                        'value' => 100000,


                    ]),


                ]


            ])


            ->add('pickupType',


                FormFieldType\ChoiceType::class, [


                    'choices' => $options['pickupTypesChoices'],


                    'label' => 'package.pickup_type.label',


                    'placeholder' => 'package.pickup_type.placeholder',


                    'translation_domain' => self::TRANSLATION_DOMAIN,


                    'multiple' => false,


                    'expanded' => false,


                    'required' => true,


                    'constraints' => [


                        new Assert\NotBlank(),


                    ]


            ])


            ->add('pickupDate', FormFieldType\DateType::class, [


                'required' => false,


                'label' => 'package.pickup_date.label',


                'translation_domain' => self::TRANSLATION_DOMAIN,


                'widget' => 'single_text',


                'constraints' => [


                    new Assert\Date(),


                ]


            ])


            ->add(


                'pickupHours',


                SettingsPickupHoursForm::class,


                [


                    'label' => false,


                ]


            )


            ->add('senderPoint', FormFieldType\TextType::class, [


                'required' => false,


                'label' => 'package.sender_point.label',


                'translation_domain' => self::TRANSLATION_DOMAIN,


            ])


            ->add('recipientPoint', FormFieldType\TextType::class, [


                'required' => false,


                'label' => 'package.recipient_point.label',


                'translation_domain' => self::TRANSLATION_DOMAIN,


            ])


            ->add('serviceId', FormFieldType\HiddenType::class, [


                'required' => false,


                'label' => false


            ])





        ;


    }





    public function configureOptions(OptionsResolver $resolver)


    {


        $resolver->setRequired([


            'sendersChoices',


            'packagesChoices',


            'servicesChoices',


            'typesChoices',


            'pickupTypesChoices',


        ]);


        $resolver->setAllowedTypes('sendersChoices', 'array');


        $resolver->setAllowedTypes('packagesChoices', 'array');


        $resolver->setAllowedTypes('servicesChoices', 'array');


        $resolver->setAllowedTypes('typesChoices', 'array');


        $resolver->setAllowedTypes('pickupTypesChoices', 'array');


    }


}