<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Entity;





use Doctrine\ORM\Mapping as ORM;





/**


 * @ORM\Table()


 * @ORM\Entity(repositoryClass="Apaczka\Prestashop\Repository\Doctrine\SenderRepository")


 */


class ApaczkaSender


{


    /**


     * @ORM\Id


     * @ORM\Column(name="id", type="integer")


     * @ORM\GeneratedValue(strategy="AUTO")


     */


    private ?int $id;





    /**


     * @ORM\Column(name="is_default", type="boolean", nullable=false)


     */


    private bool $isDefault = false;





    /**


     * @ORM\Column(name="company_name", type="string", nullable=true, length=50)


     */


    private ?string $companyName;





    /**


     * @ORM\Column(name="firstname", type="string", nullable=false, length=50)


     */


    private string $firstname;





    /**


     * @ORM\Column(name="lastname", type="string", nullable=false, length=50)


     */


    private string $lastname;





    /**


     * @ORM\Column(name="street", type="string", nullable=false, length=50)


     */


    private string $street;





    /**


     * @ORM\Column(name="home_number", type="string", nullable=false, length=10)


     */


    private string $homeNumber;





    /**


     * @ORM\Column(name="flat_number", type="string", nullable=true, length=10)


     */


    private ?string $flatNumber;





    /**


     * @ORM\Column(name="post_code", type="string", nullable=false, length=6)


     */


    private string $postCode;





    /**


     * @ORM\Column(name="city", type="string", nullable=false, length=50)


     */


    private string $city;





    /**


     * @ORM\Column(name="contact_person", type="string", nullable=false, length=50)


     */


    private string $contactPerson;





    /**


     * @ORM\Column(name="phone_number", type="string", nullable=false, length=9)


     */


    private string $phoneNumber;





    /**


     * @ORM\Column(name="email", type="string", nullable=false, length=255)


     */


    private string $email;





    /**


     * @ORM\Column(name="account_number", type="string", nullable=false, length=35)


     */


    private string $accountNumber;





    /**


     * @ORM\Column(name="template_name", type="string", nullable=true, length=50)


     */


    private ?string $templateName;








    public function getCity(): string


    {


        return $this->city;


    }





    public function setCity(string $city): void


    {


        $this->city = $city;


    }





    public function getCompanyName(): string


    {


        return $this->companyName;


    }





    public function setCompanyName(string $companyName): void


    {


        $this->companyName = $companyName;


    }





    public function getFirstname(): string


    {


        return $this->firstname;


    }





    public function setFirstname(string $firstname): void


    {


        $this->firstname = $firstname;


    }





    public function getLastname(): string


    {


        return $this->lastname;


    }








    public function setLastname(string $lastname): void


    {


        $this->lastname = $lastname;


    }





    public function getStreet(): string


    {


        return $this->street;


    }





    public function setStreet(string $street): void


    {


        $this->street = $street;


    }


    public function getHomeNumber(): string


    {


        return $this->homeNumber;


    }





    public function setHomeNumber(string $homeNumber): void


    {


        $this->homeNumber = $homeNumber;


    }





    public function getFlatNumber(): ?string


    {


        return $this->flatNumber;


    }





    public function setFlatNumber(?string $flatNumber): void


    {


        $this->flatNumber = $flatNumber;


    }





    public function getPostCode(): string


    {


        return $this->postCode;


    }





    public function setPostCode(string $postCode): void


    {


        $this->postCode = $postCode;


    }





    public function getContactPerson(): string


    {


        return $this->contactPerson;


    }





    public function setContactPerson(string $contactPerson): void


    {


        $this->contactPerson = $contactPerson;


    }





    public function getPhoneNumber(): string


    {


        return $this->phoneNumber;


    }





    public function setPhoneNumber(string $phoneNumber): void


    {


        $this->phoneNumber = $phoneNumber;


    }





    public function getEmail(): string


    {


        return $this->email;


    }





    public function setEmail(string $email): void


    {


        $this->email = $email;


    }





    public function getAccountNumber(): string


    {


        return $this->accountNumber;


    }





    public function setAccountNumber(string $accountNumber): void


    {


        $this->accountNumber = $accountNumber;


    }





    public function getTemplateName(): ?string


    {


        return $this->templateName;


    }





    public function setTemplateName(?string $templateName): void


    {


        $this->templateName = $templateName;


    }





    public function isDefault(): bool


    {


        return $this->isDefault;


    }





    public function setIsDefault(bool $isDefault): void


    {


        $this->isDefault = $isDefault;


    }





    public function getId(): ?int


    {


        return $this->id;


    }





    public function toArray(): array


    {


          return [


            'id' => $this->getId(),


            'companyName' => $this->getCompanyName(),


            'firstname' => $this->getFirstname(),


            'lastname' => $this->getLastname(),


            'street' => $this->getStreet(),


            'homeNumber' => $this->getHomeNumber(),


            'flatNumber' => $this->getFlatNumber(),


            'postCode' => $this->getPostCode(),


            'city' => $this->getCity(),


            'contactPerson' => $this->getContactPerson(),


            'phoneNumber' => $this->getPhoneNumber(),


            'email' => $this->getEmail(),


            'accountNumber' => $this->getAccountNumber(),


            'templateName' => $this->getTemplateName(),


          ];


    }


}