<?php







declare(strict_types=1);







namespace Apaczka\Prestashop\Entity;







use Doctrine\ORM\Mapping as ORM;







/**



 * @ORM\Table()



 * @ORM\Entity(repositoryClass="Apaczka\Prestashop\Repository\Doctrine\PackageRepository")



 */



class ApaczkaPackage



{







    /**



     * @ORM\Id



     * @ORM\Column(name="id", type="integer")



     * @ORM\GeneratedValue(strategy="AUTO")



     */



    private ?int $id;







    /**



     * @ORM\Column(name="is_default", type="boolean", nullable=false)



     */



    private bool $isDefault = false;







    /**



     * @ORM\Column(name="service", type="integer", nullable=false)



     */



    public int $service;







    /**



     * @ORM\Column(name="package_type", type="string", nullable=false, length=50)



     */



    private string $type;







    /**



     * @ORM\Column(name="package_length", type="integer", nullable=false, length=3)



     */



    private int $length;







    /**



     * @ORM\Column(name="package_width", type="integer", nullable=false, length=3)



     */



    private int $width;







    /**



     * @ORM\Column(name="package_heigth", type="integer", nullable=false, length=3)



     */



    private int $height;







    /**



     * @ORM\Column(name="package_weight", type="integer", nullable=false, length=4)



     */



    private int $weight;







    /**



     * @ORM\Column(name="package_content", type="string", nullable=true)



     */



    private ?string $content;







    /**



     * @ORM\Column(name="package_out_of_standard", type="boolean", nullable=false)



     */



    private bool $outOfStandard = false;







    /**



     * @ORM\Column(name="template_name", type="string", nullable=true, length=50)



     */



    private ?string $templateName;







    public function getId(): ?int



    {



        return $this->id;



    }







    public function isDefault(): bool



    {



        return $this->isDefault;



    }







    public function setIsDefault(bool $isDefault): void



    {



        $this->isDefault = $isDefault;



    }







    public function getService(): int



    {



        return $this->service;



    }







    public function setService(int $service): void



    {



        $this->service = $service;



    }







    public function getType(): string



    {



        return $this->type;



    }







    public function setType(string $type): void



    {



        $this->type = $type;



    }







    public function getLength(): int



    {



        return $this->length;



    }







    public function setLength(int $length): void



    {



        $this->length = $length;



    }







    public function getWidth(): int



    {



        return $this->width;



    }







    public function setWidth(int $width): void



    {



        $this->width = $width;



    }







    public function getHeight(): int



    {



        return $this->height;



    }







    public function setHeight(int $height): void



    {



        $this->height = $height;



    }







    public function getWeight(): int



    {



        return $this->weight;



    }



    public function setWeight(int $weight): void



    {



        $this->weight = $weight;



    }







    public function getContent(): ?string



    {



        return $this->content;



    }







    public function setContent(?string $content): void



    {



        $this->content = $content;



    }







    public function isOutOfStandard(): bool



    {



        return $this->outOfStandard;



    }







    public function setOutOfStandard(bool $outOfStandard): void



    {



        $this->outOfStandard = $outOfStandard;



    }







    public function getTemplateName(): ?string



    {



        return $this->templateName;



    }







    public function setTemplateName(?string $templateName): void



    {



        $this->templateName = $templateName;



    }







    public function toArray(): array



    {



        return [



            'id' => $this->getId(),



            'isDefault' => $this->isDefault(),



            'service' => $this->getService(),



            'type' => $this->getType(),



            'length' => $this->getLength(),



            'width' => $this->getWidth(),



            'weight' => $this->getWeight(),



            'content' => $this->getContent(),



            'isOutOfStandard' => $this->isOutOfStandard(),



            'templateName' => $this->getTemplateName(),



        ];



    }







}