<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Controller\Admin;





use Apaczka\Prestashop\Form\Admin\PackageForm;


use Apaczka\Prestashop\Model\PackageRepositoryInterface;


use Apaczka\Prestashop\Model\ServicesRepositoryInterface;


use PrestaShopBundle\Controller\Admin\FrameworkBundleAdminController;


use Symfony\Component\HttpFoundation\JsonResponse;


use Symfony\Component\HttpFoundation\Request;


use Symfony\Component\HttpFoundation\Response;





class PackageTemplateController extends FrameworkBundleAdminController


{


    protected const TPL_DIR = '@Modules/apaczkashipments/views/templates/admin/';


    private PackageRepositoryInterface $packageRepository;


    private ServicesRepositoryInterface $servicesRepository;





    public function __construct(


        PackageRepositoryInterface $packageRepository,


        ServicesRepositoryInterface $servicesRepository


    ) {


        $this->packageRepository = $packageRepository;


        $this->servicesRepository = $servicesRepository;


    }





    public function save(Request $request): Response


    {


        $template = self::TPL_DIR . 'settings/form/settings_package.html.twig';





        $form =  $this->createForm(


            PackageForm::class,


            null, [


                'csrf_protection' => false,


                'servicesChoices' => array_flip($this->servicesRepository->getChosenOptions()),


                'typesChoices' => array_flip($this->packageRepository->getTypeOptions())


            ]);


        $form->handleRequest($request);


        $saved = false;





        if ($form->isSubmitted() && $form->isValid()) {


            $package = $form->getData();


            $package->setIsDefault(false);


            $this->packageRepository->add($package);


            $saved = true;


        }





        return new JsonResponse([


            'content' => $this->renderView($template, [


                'form' => $form->createView(),


                'templateSaved' => $saved,


                'hasPackage' => true,


            ]),


            'saved' => $saved,


        ]);


    }





    public function delete(Request $request, int $id): Response


    {


        $package = $this->packageRepository->get($id);





        if (null !== $package && !$package->isDefault()) {


            $this->packageRepository->remove($package);


        }





        return new JsonResponse(['deleted' => true, 'templateId' => $id]);


    }





    public function list(Request $request): Response


    {


        $template = self::TPL_DIR . 'package_template/list.html.twig';


        $packages = $this->packageRepository->list(['isDefault' => false]);





        return new JsonResponse(['content' => $this->renderView($template, ['packages'=> $packages])]);


    }


}