<?php







declare(strict_types = 1);







if (!defined('_PS_VERSION_')) {



    exit;



}







require __DIR__ . '/vendor/autoload.php';







use Apaczka\Prestashop\Provider\RouteProvider;



use Apaczka\Prestashop\Provider\ServiceProvider;







class Apaczkashipments extends Module



{



    private ServiceProvider $serviceProvider;



    private RouteProvider $routeProvider;







    public function __construct()



    {



        $this->serviceProvider = ServiceProvider::getInstance();



        $this->routeProvider = RouteProvider::getInstance();



        $this->serviceProvider->getSetupService()->start($this);



        parent::__construct();



        $this->serviceProvider->getSetupService()->finish($this);



    }







    public function install(): bool



    {



        if (Shop::isFeatureActive()) {



            Shop::setContext(Shop::CONTEXT_ALL);



        }







        return parent::install()



            && $this->serviceProvider->getInstallService()->install($this)



            && $this->registerHook('displayAdminOrder')



            && $this->registerHook('displayBackOfficeHeader')



            && $this->registerHook('actionAdminControllerSetMedia');



    }







    public function uninstall(): bool



    {



        return parent::uninstall()



            && $this->serviceProvider->getUninstallService()->uninstall($this)



            && $this->unregisterHook('displayAdminOrder')



            && $this->unregisterHook('displayBackOfficeHeader')



            && $this->unregisterHook('actionAdminControllerSetMedia')







            ;



    }







    public function enable($force_all = false): bool



    {



        return parent::enable($force_all)



            && $this->serviceProvider->getInstallService()->enable($this);



    }







    public function disable($force_all = false): bool



    {



        return parent::disable($force_all)



            && $this->serviceProvider->getUninstallService()->disable($this);



    }







    public function isUsingNewTranslationSystem(): bool



    {



        return true;



    }







    public function getContent()



    {



        Tools::redirectAdmin($this->routeProvider->getSettingsUrl());



    }







    public function hookDisplayAdminOrder($params)



    {



        return $this->serviceProvider->getTemplating()->render(



            '@Modules/apaczkashipments/views/templates/admin/order/placeholder.html.twig',



            [



                'orderId' => (int) $params['id_order']



            ]



        );



    }







    public function hookDisplayBackOfficeHeader()



    {



        $controller = $this->context->controller;



        $controller->addCss($this->_path . 'views/css/apaczka.css');



    }







    public function hookActionAdminControllerSetMedia($params)



    {



        $controller = $this->context->controller;



        $controller->addJs($this->_path . 'views/js/apaczka.lib.js');



        $controller->addJs($this->_path . 'views/js/apaczka.init.js');



        $controller->addJs('https://mapa.apaczka.pl/client/apaczka.map.js');



    }



}