<?php

class ModelShippingApaczka extends Model {

    private $soap_login = 'apilogin';
    private $soap_password = 'apipassword';
    private $soap_apikey = 'apikey';
    private $soap_server = 'https://app.apaczka.pl/webservice/order';
    private $soap_test_server = 'http://test.apaczka.pl/webservice/order';
    private $soap_wsdl_url_suffix = '?wsdl';
    public $apaczka_url = 'https://app.apaczka.pl/';
    public $apaczka_test_url = 'http://test.apaczka.pl/';
    public $orderList_url_suffix = 'orderList.htm';
    public $waybillDocument_url_suffix = 'collectiveWaybillDocument.htm?orderId_#id#=on';
    private $soap = null;
    private $soap_authorization = array();

    function __construct() {
        try {
            $client = $this->soap = new SoapClient($this->soap_server . $this->soap_wsdl_url_suffix, array('location' => $this->soap_server, 'connection_timeout' => 10, 'trace' => true));
        } catch (Exception $e) {
            echo "Error in connection: ";
            echo $e . getMessage();
        }
    }

    public function connect($auth) {
        $this->soap_login = $auth['soap_login'];
        $this->soap_password = $auth['soap_password'];
        $this->soap_apikey = $auth['soap_apikey'];

        $this->soap_authorization = array('apiKey' => $this->soap_apikey, 'login' => $this->soap_login, 'password' => $this->soap_password);

        if (isset($auth['soap_test']) && $auth['soap_test'] == true) {
            $this->soap_server = $this->soap_test_server;
            $this->apaczka_url = $this->apaczka_test_url;
        }
        try {
            $this->soap = new SoapClient($this->soap_server . $this->soap_wsdl_url_suffix, array('location' => $this->soap_server, 'trace' => true));
        }catch (Exception $e){
            return array('soap_status' => false, 'soap_message' => 'Błąd SOAP. Upewnij się, że na serwerze zainstalowany jest moduł PHP SOAP potrzebny do obsługi Webservice\'u.');
        }

        if (!$this->soap) {
            return array('soap_status' => false, 'soap_message' => 'Błąd SOAP. Upewnij się, że na serwerze zainstalowany jest moduł PHP SOAP potrzebny do obsługi Webservice\'u.');
        }
        $result = $this->soap->validateAuthData(array('Authorization' => $this->soap_authorization));

        if (isset($result->return) && isset($result->return->isValid) && $result->return->isValid === true) {
            return array('soap_status' => true);
        } else {
            if (isset($result->return) && isset($result->return->result) && isset($result->return->result->messages) && isset($result->return->result->messages->Message) && isset($result->return->result->messages->Message->code)) {
                $errorMessage = $result->return->result->messages->Message->code . (isset($result->return->result->messages->Message->description) ? ' - ' . $result->return->result->messages->Message->description : '');
            }
            unset($this->soap);
            return array('soap_status' => false, 'soap_message' => (isset($errorMessage) ? '(' . $errorMessage . ') ' : '') . 'Upewnij się, że podałeś prawidłowe dane w konfiguracji modułu wysyłki apaczka.pl.');
        }
    }



    public function placeOrder($soap_order) {
        if (!$this->soap)
            return array('soap_status' => false, 'soap_message' => 'Błąd wewnętrzny. Skontaktuj sie z autorem modułu.');

        if (!$this->soap_authorization)
            return array('soap_status' => false, 'soap_message' => 'Błąd wewnętrzny. Skontaktuj sie z autorem modułu.');

        $placeOrderRequest = array('authorization' => $this->soap_authorization, 'order' => $soap_order);

        try {
            $result = $this->soap->placeOrder(array('PlaceOrderRequest' => $placeOrderRequest));

        } catch (Exception $e) {

            return array('soap_status' => false, 'soap_message' => 'Funkcja placeOrder: Błąd SOAP ' . $e->faultstring . "</br>END</br>");
        }

        if (isset($result->return) && isset($result->return->order) && isset($result->return->order->id)) {
            return array('soap_status' => true, 'order' => $this->object_to_array($result->return->order));
        } else {
            if (isset($result->return) && isset($result->return->result) && isset($result->return->result->messages) && isset($result->return->result->messages->Message) && isset($result->return->result->messages->Message->code)) {
                $errorMessage = $result->return->result->messages->Message->code . (isset($result->return->result->messages->Message->description) ? ' - ' . $result->return->result->messages->Message->description : '');
            }

            return array('soap_status' => false, 'soap_message' => (isset($errorMessage) ? '(' . $errorMessage . ') ' : '') . 'Kwota pobrania musi być większa bądź równa kwocie ubezpieczenia. Upewnij się, że podałeś prawidłowe dane w konfiguracji modułu wysyłki apaczka.pl oraz wypełniłeś wszystkie wymagane pola w zamówieniu.');
        }

        return $result;
    }

    public function getCountries() {
        if (!$this->soap)
            return array('soap_status' => false, 'soap_message' => 'Błąd wewnętrzny. Skontaktuj sie z autorem modułu.');

        if (!$this->soap_authorization)
            return array('soap_status' => false, 'soap_message' => 'Błąd wewnętrzny. Skontaktuj sie z autorem modułu.');

        $countryRequest = array('authorization' => $this->soap_authorization);

        try {
            $result = $this->soap->getCountries(array('CountryRequest' => $countryRequest));

        } catch (Exception $e) {
            return array('soap_status' => false, 'soap_message' => 'Błąd SOAP ' . $e->faultstring);
        }

        if (
                isset($result->return) && isset($result->return->countries) && isset($result->return->countries->Country) && is_array($result->return->countries->Country)
        ) {
            foreach ($result->return->countries->Country as $country) {
                $countries[$country->id] = $country->name;
            }
            return array('soap_status' => true, 'countries' => $countries);
        } else {
            if (
                    isset($result->return) && isset($result->return->result) && isset($result->return->result->messages) && isset($result->return->result->messages->Message) && isset($result->return->result->messages->Message->code)
            )
                $errorMessage = $result->return->result->messages->Message->code . (isset($result->return->result->messages->Message->description) ? ' - ' . $result->return->result->messages->Message->description : '');

            return array('soap_status' => false, 'soap_message' => (isset($errorMessage) ? '(' . $errorMessage . ') ' : ''));
        }

        return $result;
    }

    public static function object_to_array(stdClass $Class) {
        $Class = (array) $Class;
        foreach ($Class as $key => $value)
            if (is_object($value) && get_class($value) === 'stdClass')
                $Class[$key] = self::object_to_array($value);

        return $Class;
    }

}

?>
