<?php

class ControllerShippingApaczka extends Controller {

    private $error = array();

    public function order_button() {
        $this->load->model('setting/setting');
        $this->load->model('sale/order');
        $this->load->model('shipping/apaczka');

        $this->data['order_id'] = $this->request->get['order_id'];
        $this->data['token'] = $this->request->get['token'];

        $order = $this->model_sale_order->getOrder($this->data['order_id']);
        $apaczka_orders = $this->model_setting_setting->getSetting('apaczka_orders');
        $apaczka_orders_return = $this->model_setting_setting->getSetting('apaczka_orders_return');

        if (isset($apaczka_orders['order_' . $this->data['order_id']])) {
            $this->data['order_status'] = unserialize($apaczka_orders['order_' . $this->data['order_id']]);
            $this->data['order_status_return'] = unserialize($apaczka_orders_return['order_' . $this->data['order_id']]);
            $this->data['waybillDocument_url'] = $this->model_shipping_apaczka->apaczka_url . str_replace('#id#', $this->data['order_status_return']['id'], $this->model_shipping_apaczka->waybillDocument_url_suffix);
        }

        $auth['soap_login'] = $this->config->get('apaczka_login');
        $auth['soap_password'] = $this->config->get('apaczka_password');
        $auth['soap_apikey'] = $this->config->get('apaczka_apikey');
        $auth['soap_test'] = $this->config->get('apaczka_test');

        $result = $this->model_shipping_apaczka->connect($auth);
        $this->data['soap_status'] = (isset($result['soap_status'])) ? $result['soap_status'] : false;
        $this->data['soap_message'] = (isset($result['soap_message'])) ? $result['soap_message'] : '';

        $this->data['orderList_url'] = $this->model_shipping_apaczka->apaczka_url . $this->model_shipping_apaczka->orderList_url_suffix;
        $this->data['apaczka_url'] = $this->model_shipping_apaczka->apaczka_url;

        if (stripos($order['shipping_method'], 'apaczka') !== false) {
            $this->template = 'shipping/apaczka_button.tpl';
            $this->response->setOutput($this->render());
        }
    }

    public function saveContact() {

        $name = $this->request->post['sender_name'];
        $addresLine1 = $this->request->post['sender_addressLine1'];
        $addresLine2 = $this->request->post['sender_addressLine2'];
        $postalCode = $this->request->post['sender_postalCode'];
        $city = $this->request->post['sender_city'];
        $countryID = $this->request->post['sender_countryID'];
        $contactName = $this->request->post['sender_contactName'];
        $phone = $this->request->post['sender_phone'];
        $email = $this->request->post['sender_email'];
        $account = $this->request->post['sender_account'];

        $this->db->query("INSERT IGNORE INTO `contacts` (`nazwa`,`adres`, `adres_cd`, `kod_pocztowy`,
                `miasto`,`osoba_kontaktowa`, `ID_kraju`,`telefon`, `email`, `konto_pobraniowe` ) 
                VALUES ('$name','$addresLine1','$addresLine2','$postalCode','$city', '$contactName', $countryID, '$phone', '$email','$account')");
    }

    //wlasciwe zamowienie
    public function placeOrder() {

        $this->load->model('shipping/apaczka');
        $this->load->model('setting/setting');
        $this->load->model('sale/order');

        $order_id = $this->request->post['order_id'];
        $order = $this->model_sale_order->getOrder($order_id);

        $soap_order = array();
        $soap_order['options'] = array();

        if (isset($this->request->post['cod']) && $this->request->post['cod']) {
            if (isset($this->request->post['accountNumber']))
                $soap_order['accountNumber'] = $this->request->post['accountNumber'];
            if (isset($this->request->post['codAmount']))
                $soap_order['codAmount'] = $this->request->post['codAmount'] * 100;
            $soap_order['options'][] = 'POBRANIE';
        }

        if (isset($this->request->post['contents'])) {
            $soap_order['contents'] = $this->request->post['contents'];
        }

        $soap_order['isDomestic'] = true;

        if (isset($this->request->post['receiver']['countryId'])) {
            if ($this->request->post['receiver']['countryId'] !== 0) {
                $soap_order['isDomestic'] = true;
            } else {
                $soap_order['isDomestic'] = false;
            }
        }
        //********************************* ZMIANY *****************************************************
        
        $soap_order['notificationDelivered'] = array('isReceiverEmail' => false, 'isReceiverSms' => false, 'isSenderEmail' => false, 'isSenderSms' => false);
        $soap_order['notificationException'] = array('isReceiverEmail' => false, 'isReceiverSms' => false, 'isSenderEmail' => false, 'isSenderSms' => false);
        $soap_order['notificationNew'] = array('isReceiverEmail' => false, 'isReceiverSms' => false, 'isSenderEmail' => false, 'isSenderSms' => false);
        $soap_order['notificationSent'] = array('isReceiverEmail' => false, 'isReceiverSms' => false, 'isSenderEmail' => false, 'isSenderSms' => false);
        
        if(isset($this->request->post['apaczka_emails']['Rdelivered'])  ){
            $soap_order['notificationDelivered']['isReceiverEmail'] = (strtolower($this->request->post['apaczka_emails']['Rdelivered'])=== "true") ? true :  FALSE;
        }
        if(isset($this->request->post['apaczka_emails']['Sdelivered'])){
            $soap_order['notificationDelivered']['isSenderEmail'] = (strtolower($this->request->post['apaczka_emails']['Sdelivered'])=== "true") ? true :  FALSE;
        }
        if(isset($this->request->post['apaczka_emails']['Rexception'])){
            $soap_order['notificationException']['isReceiverEmail'] = (strtolower($this->request->post['apaczka_emails']['Rexception'])=== "true") ? true :  FALSE;
        }
        if(isset($this->request->post['apaczka_emails']['Sexception'])){
            $soap_order['notificationException']['isSenderEmail'] = (strtolower($this->request->post['apaczka_emails']['Sexception'])=== "true") ? true :  FALSE;
        }
        if(isset($this->request->post['apaczka_emails']['Rnew'])){
            $soap_order['notificationNew']['isReceiverEmail'] = (strtolower($this->request->post['apaczka_emails']['Rnew'])=== "true") ? true :  FALSE;
        }
        if(isset($this->request->post['apaczka_emails']['Snew'])){
            $soap_order['notificationNew']['isSenderEmail'] = (strtolower($this->request->post['apaczka_emails']['Snew'])=== "true") ? true :  FALSE;
        }  
        if(isset($this->request->post['apaczka_emails']['Rsent'])){
            $soap_order['notificationSent']['isReceiverEmail'] = (strtolower($this->request->post['apaczka_emails']['Rsent'])=== "true") ? true :  FALSE;
        }
        if(isset($this->request->post['apaczka_emails']['Ssent'])){
            $soap_order['notificationSent']['isSenderEmail'] = (strtolower($this->request->post['apaczka_emails']['Ssent'])=== "true") ? true :  FALSE;
        }

        //******************************** /ZMIANY *********************************************

        if (isset($this->request->post['pickupDate'])) {
            $soap_order['pickupDate'] = $this->request->post['pickupDate'];
        }
        if (isset($this->request->post['pickupTimeFrom'])) {
            $soap_order['pickupTimeFrom'] = $this->request->post['pickupTimeFrom'];
        }
        if (isset($this->request->post['pickupTimeTo'])) {
            $soap_order['pickupTimeTo'] = $this->request->post['pickupTimeTo'];
        }

        if (isset($this->request->post['receiver']['addressLine1'])) {
            $soap_order['receiver']['addressLine1'] = $this->request->post['receiver']['addressLine1'];
        }
        if (isset($this->request->post['receiver']['addressLine2'])) {
            $soap_order['receiver']['addressLine2'] = $this->request->post['receiver']['addressLine2'];
        }
        if (isset($this->request->post['receiver']['city'])) {
            $soap_order['receiver']['city'] = $this->request->post['receiver']['city'];
        }
        if (isset($this->request->post['receiver']['contactName'])) {
            $soap_order['receiver']['contactName'] = $this->request->post['receiver']['contactName'];
        }
        if (isset($this->request->post['receiver']['countryId'])) {
            $soap_order['receiver']['countryId'] = $this->request->post['receiver']['countryId'];
        }
        if (isset($this->request->post['receiver']['email'])) {
            $soap_order['receiver']['email'] = $this->request->post['receiver']['email'];
        }
        if (isset($this->request->post['receiver']['name'])) {
            $soap_order['receiver']['name'] = $this->request->post['receiver']['name'];
        }
        if (isset($this->request->post['receiver']['phone'])) {
            $soap_order['receiver']['phone'] = $this->request->post['receiver']['phone'];
        }
        if (isset($this->request->post['receiver']['postalCode'])) {
            $soap_order['receiver']['postalCode'] = $this->request->post['receiver']['postalCode'];
        }
        if (isset($this->request->post['receiver']['stateCode'])) {
            $soap_order['receiver']['stateCode'] = $this->request->post['receiver']['stateCode'];
        }

        if (isset($this->request->post['referenceNumber'])) {
            $soap_order['referenceNumber'] = $this->request->post['referenceNumber'];
        }

        if (isset($this->request->post['sender']['addressLine1'])) {
            $soap_order['sender']['addressLine1'] = $this->request->post['sender']['addressLine1'];
        }
        if (isset($this->request->post['sender']['addressLine2'])) {
            $soap_order['sender']['addressLine2'] = $this->request->post['sender']['addressLine2'];
        }
        if (isset($this->request->post['sender']['city'])) {
            $soap_order['sender']['city'] = $this->request->post['sender']['city'];
        }
        if (isset($this->request->post['sender']['contactName'])) {
            $soap_order['sender']['contactName'] = $this->request->post['sender']['contactName'];
        }
        if (isset($this->request->post['sender']['countryId'])) {
            $soap_order['sender']['countryId'] = $this->request->post['sender']['countryId'];
        }
        if (isset($this->request->post['sender']['email'])) {
            $soap_order['sender']['email'] = $this->request->post['sender']['email'];
        }
        if (isset($this->request->post['sender']['name'])) {
            $soap_order['sender']['name'] = $this->request->post['sender']['name'];
        }
        if (isset($this->request->post['sender']['phone'])) {
            $soap_order['sender']['phone'] = $this->request->post['sender']['phone'];
        }
        if (isset($this->request->post['sender']['postalCode'])) {
            $soap_order['sender']['postalCode'] = $this->request->post['sender']['postalCode'];
        }
        if (isset($this->request->post['sender']['stateCode'])) {
            $soap_order['sender']['stateCode'] = $this->request->post['sender']['stateCode'];
        }

        if (isset($this->request->post['orderPickupType'])) {
            $soap_order['orderPickupType'] = $this->request->post['orderPickupType'];
        }
        if (isset($this->request->post['emails'])) {
            $soap_order['emails'] = $this->request->post['emails'];
        }        
        

        
        if (isset($this->request->post['serviceCode'])) {
            $soap_order['serviceCode'] = $this->request->post['serviceCode'];
        }

        if (isset($this->request->post['shipments'][0]['dimension1'])) {
            $soap_order['shipments'][0]['dimension1'] = $this->request->post['shipments'][0]['dimension1'];
        }
        if (isset($this->request->post['shipments'][0]['dimension2'])) {
            $soap_order['shipments'][0]['dimension2'] = $this->request->post['shipments'][0]['dimension2'];
        }
        if (isset($this->request->post['shipments'][0]['dimension3'])) {
            $soap_order['shipments'][0]['dimension3'] = $this->request->post['shipments'][0]['dimension3'];
        }

        $soap_order['shipments'][0]['options'] = array();

        $soap_order['shipments'][0]['position'] = 0;

        $soap_order['shipments'][0]['shipmentTypeCode'] = "PACZ";   //TYLKO PACZKI!

        if (isset($this->request->post['insurance']) && $this->request->post['insurance']) {
            if (isset($this->request->post['shipments'][0]['shipmentValue'])){
            $soap_order['shipments'][0]['shipmentValue'] = $this->request->post['shipments'][0]['shipmentValue'] * 100;}
            $soap_order['shipments'][0]['options'][] = 'UBEZP';
        }

        if (isset($this->request->post['shipments'][0]['weight'])) {
            $soap_order['shipments'][0]['weight'] = $this->request->post['shipments'][0]['weight'];
        }

        $auth['soap_login'] = $this->config->get('apaczka_login');
        $auth['soap_password'] = $this->config->get('apaczka_password');
        $auth['soap_apikey'] = $this->config->get('apaczka_apikey');
        $auth['soap_test'] = $this->config->get('apaczka_test');
        $result = $this->model_shipping_apaczka->connect($auth);
        $this->data['soap_status'] = (isset($result['soap_status'])) ? $result['soap_status'] : false;
        $this->data['soap_message'] = (isset($result['soap_message'])) ? $result['soap_message'] : '';

        if ($result['soap_status'] === false) {
            echo "ERROR:" . str_replace(":", " - ", $result['soap_message']);
            return;
        }

        $result = $this->model_shipping_apaczka->placeOrder($soap_order);

        $this->data['soap_status'] = (isset($result['soap_status'])) ? $result['soap_status'] : false;
        $this->data['soap_message'] = (isset($result['soap_message'])) ? $result['soap_message'] : '';

        if ($result['soap_status'] === false) {
            echo 'ERROR:' . str_replace(":", " - ", $result['soap_message']);
            return;
        }

        echo 'SUCCESS:' . $result['order']['id'];

        $apaczka_orders = $this->model_setting_setting->getSetting('apaczka_orders');
        $apaczka_orders_return = $this->model_setting_setting->getSetting('apaczka_orders_return');
        $apaczka_orders_return['order_' . $order_id] = serialize($result['order']);
        $apaczka_orders['order_' . $order_id] = serialize($soap_order);

        $this->model_setting_setting->editSetting('apaczka_orders', $apaczka_orders);
        $this->model_setting_setting->editSetting('apaczka_orders_return', $apaczka_orders_return);
        
        
    }

    //Wyswielta proponowane dane do zamowienia
    public function orderDialog() {
        
                
        $reply = $this->db->query("SELECT * from contacts;");
        if ($reply->num_rows > 0) {
            foreach ($reply->rows as $row) {
                $soap_order['contacts'][$row["contact_id"]]['nazwa'] = $row["nazwa"];
                $soap_order['contacts'][$row["contact_id"]]['adres'] = $row["adres"];
                $soap_order['contacts'][$row["contact_id"]]['adres_cd'] = $row["adres_cd"];
                $soap_order['contacts'][$row["contact_id"]]['kod_pocztowy'] = $row["kod_pocztowy"];
                $soap_order['contacts'][$row["contact_id"]]['miasto'] = $row["miasto"];
                $soap_order['contacts'][$row["contact_id"]]['ID_kraju'] = $row["ID_kraju"];
                $soap_order['contacts'][$row["contact_id"]]['osoba_kontaktowa'] = $row["osoba_kontaktowa"];
                $soap_order['contacts'][$row["contact_id"]]['telefon'] = $row["telefon"];
                $soap_order['contacts'][$row["contact_id"]]['email'] = $row["email"];
                $soap_order['contacts'][$row["contact_id"]]['konto_pobraniowe'] = $row["konto_pobraniowe"];
            }
        } 
        
        $this->load->language('shipping/apaczka');
        $this->load->model('shipping/apaczka');
        $this->load->model('setting/setting');
        $this->load->model('sale/order');

        $order_id = $this->request->get['order_id'];

        $apaczka_orders = $this->model_setting_setting->getSetting('apaczka_orders');
        $apaczka_orders_return = $this->model_setting_setting->getSetting('apaczka_orders_return');

        if (isset($apaczka_orders['order_' . $order_id]) && isset($this->data['order_id'])) {
            $this->data['order_status'] = unserialize($apaczka_orders['order_' . $this->data['order_id']]);
            $this->data['order_status_return'] = unserialize($apaczka_orders_return['order_' . $this->data['order_id']]);
        }

        $auth['soap_login'] = $this->config->get('apaczka_login');
        $auth['soap_password'] = $this->config->get('apaczka_password');
        $auth['soap_apikey'] = $this->config->get('apaczka_apikey');
        $auth['soap_test'] = $this->config->get('apaczka_test');
        $result = $this->model_shipping_apaczka->connect($auth);
        $this->data['soap_status'] = (isset($result['soap_status'])) ? $result['soap_status'] : false;
        $this->data['soap_message'] = (isset($result['soap_message'])) ? $result['soap_message'] : '';

        $result = $this->model_shipping_apaczka->getCountries();
        if ($result['soap_status'] === true){
        $this->data['countries'] = $result['countries'];}

        $this->data['token'] = $this->request->get['token'];
        $this->data['order'] = $order = $this->model_sale_order->getOrder($order_id);

        $soap_order['accountNumber'] = $this->config->get('apaczka_account');
        $soap_order['codAmount'] = "";
        $soap_order['contents'] = "";
        $soap_order['isDomestic'] = "";

        $soap_order['receiver']['addressLine1'] = $order['shipping_address_1'];
        $soap_order['receiver']['addressLine2'] = $order['shipping_address_2'];
        $soap_order['receiver']['city'] = $order['shipping_city'];
        $soap_order['receiver']['contactName'] = $order['shipping_firstname'] . ' ' . $order['shipping_lastname'];
        
        $soap_order['receiver']['name'] = ((!empty($order['shipping_company']) )?($order['shipping_company']):($order['shipping_firstname'].' '. $order['shipping_lastname']));
        
        $soap_order['receiver']['countryId'] = "";
        $soap_order['receiver']['email'] = $order['email'];
        $soap_order['receiver']['phone'] = $order['telephone'];
        $soap_order['receiver']['postalCode'] = $order['shipping_postcode'];
        
        $soap_order['referenceNumber'] = 'OpenCart_order_' . $order_id;

        $soap_order['sender']['addressLine1'] = $this->config->get('apaczka_sender_address1');
        $soap_order['sender']['addressLine2'] = $this->config->get('apaczka_sender_address2');
        $soap_order['sender']['city'] = $this->config->get('apaczka_sender_city');
        $soap_order['sender']['contactName'] = $this->config->get('apaczka_sender_contactName');
        $soap_order['sender']['name'] = $this->config->get('apaczka_sender_name');
        $soap_order['sender']['countryId'] = "";
        $soap_order['sender']['email'] = $this->config->get('apaczka_sender_email');
        $soap_order['sender']['phone'] = $this->config->get('apaczka_sender_phone');
        $soap_order['sender']['postalCode'] = $this->config->get('apaczka_sender_postcode');

        $soap_order['serviceCode'] = $this->config->get('apaczka_serviceCode');
        $soap_order['orderPickupType'] = $this->config->get('apaczka_orderPickupType');

        

        
        $soap_order['shipments'][0]['dimension1'] = "";
        $soap_order['shipments'][0]['dimension2'] = "";
        $soap_order['shipments'][0]['dimension3'] = "";
        $soap_order['shipments'][0]['options'] = $this->config->get('apaczka_insurance');
        $soap_order['shipments'][0]['position'] = 0;
        $soap_order['shipments'][0]['shipmentTypeCode'] = "";
        $soap_order['shipments'][0]['shipmentValue'] = 0;
        $soap_order['shipments'][0]['weight'] = $this->config->get('apaczka_weight'); //"";
        
        $soap_order['notifications']=$this->config->get('apaczka_emails');
                            
        $this->data['soap_order'] = $soap_order;

        $this->data['orderList_url'] = $this->model_shipping_apaczka->apaczka_url . $this->model_shipping_apaczka->orderList_url_suffix;

        $this->template = 'shipping/apaczka_order.tpl';

        $this->response->setOutput($this->render(true));
    }

    public function index() {

        $this->load->language('shipping/apaczka');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->validate())) {
            $this->model_setting_setting->editSetting('apaczka', $this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $this->redirect($this->url->link('extension/shipping', 'token=' . $this->session->data['token'], 'SSL'));
        }

        $this->data['heading_title'] = $this->language->get('heading_title');

        $this->data['text_enabled'] = $this->language->get('text_enabled');
        $this->data['text_disabled'] = $this->language->get('text_disabled');
        $this->data['text_all_zones'] = $this->language->get('text_all_zones');
        $this->data['text_none'] = $this->language->get('text_none');

        $this->data['entry_api_login'] = $this->language->get('entry_api_login');
        $this->data['entry_api_password'] = $this->language->get('entry_api_password');
        $this->data['entry_api_key'] = $this->language->get('entry_api_key');
        $this->data['entry_api_test'] = $this->language->get('entry_api_test');
        $this->data['entry_status'] = $this->language->get('entry_status');
        $this->data['entry_sort_order'] = $this->language->get('entry_sort_order');
        $this->data['entry_tax_class'] = $this->language->get('entry_tax_class');
        $this->data['entry_shipment_price'] = $this->language->get('entry_shipment_price');
        $this->data['entry_serviceCode'] = $this->language->get('entry_serviceCode');

        $this->data['entry_sender_name'] = $this->language->get('entry_sender_name');
        $this->data['entry_sender_contactName'] = $this->language->get('entry_sender_contactName');
        $this->data['entry_sender_address1'] = $this->language->get('entry_sender_address1');
        $this->data['entry_sender_address2'] = $this->language->get('entry_sender_address2');
        $this->data['entry_sender_postcode'] = $this->language->get('entry_sender_postcode');
        $this->data['entry_sender_city'] = $this->language->get('entry_sender_city');
        $this->data['entry_sender_email'] = $this->language->get('entry_sender_email');
        $this->data['entry_sender_phone'] = $this->language->get('entry_sender_phone');
        $this->data['entry_account'] = $this->language->get('entry_account');

        $this->data['button_save'] = $this->language->get('button_save');
        $this->data['button_cancel'] = $this->language->get('button_cancel');

        $this->data['tab_general'] = $this->language->get('tab_general');

        if (isset($this->error['warning'])) {
            $this->data['error_warning'] = $this->error['warning'];
        } else {
            $this->data['error_warning'] = '';
        }

        $this->data['breadcrumbs'] = array();

        $this->data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
            'separator' => false
        );

        $this->data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_shipping'),
            'href' => $this->url->link('extension/shipping', 'token=' . $this->session->data['token'], 'SSL'),
            'separator' => ' :: '
        );

        $this->data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('shipping/apaczka', 'token=' . $this->session->data['token'], 'SSL'),
            'separator' => ' :: '
        );

        $this->data['action'] = $this->url->link('shipping/apaczka', 'token=' . $this->session->data['token'], 'SSL');

        $this->data['cancel'] = $this->url->link('extension/shipping', 'token=' . $this->session->data['token'], 'SSL');

        if (isset($this->request->post['apaczka_login'])) {
            $this->data['apaczka_login'] = $this->request->post['apaczka_login'];
        } else {
            $this->data['apaczka_login'] = $this->config->get('apaczka_login');
        }
        if (isset($this->request->post['apaczka_password'])) {
            $this->data['apaczka_password'] = $this->request->post['apaczka_password'];
        } else {
            $this->data['apaczka_password'] = $this->config->get('apaczka_password');
        }
        if (isset($this->request->post['apaczka_apikey'])) {
            $this->data['apaczka_apikey'] = $this->request->post['apaczka_apikey'];
        } else {
            $this->data['apaczka_apikey'] = $this->config->get('apaczka_apikey');
        }
        if (isset($this->request->post['apaczka_test'])) {
            $this->data['apaczka_test'] = $this->request->post['apaczka_test'];
        } else {
            $this->data['apaczka_test'] = $this->config->get('apaczka_test');
        }
        if (isset($this->request->post['apaczka_status'])) {
            $this->data['apaczka_status'] = $this->request->post['apaczka_status'];
        } else {
            $this->data['apaczka_status'] = $this->config->get('apaczka_status');
        }
        if (isset($this->request->post['apaczka_tax_class_id'])) {
            $this->data['apaczka_tax_class_id'] = $this->request->post['apaczka_tax_class_id'];
        } else {
            $this->data['apaczka_tax_class_id'] = $this->config->get('apaczka_tax_class_id');
        }
        if (isset($this->request->post['apaczka_sort_order'])) {
            $this->data['apaczka_sort_order'] = $this->request->post['apaczka_sort_order'];
        } else {
            $this->data['apaczka_sort_order'] = $this->config->get('apaczka_sort_order');
        }
        if (isset($this->request->post['apaczka_shipment_price'])) {
            $this->data['apaczka_shipment_price'] = $this->request->post['apaczka_shipment_price'];
        } else {
            $this->data['apaczka_shipment_price'] = $this->config->get('apaczka_shipment_price');
        }
        if (isset($this->request->post['apaczka_serviceCode'])) {
            $this->data['apaczka_serviceCode'] = $this->request->post['apaczka_serviceCode'];
        } else {
            $this->data['apaczka_serviceCode'] = $this->config->get('apaczka_serviceCode');
        }
        /**
         * @var integer apaczka_insurance, 0 no, 1 yes 
         */
        if (isset($this->request->post['apaczka_insurance'])) {
            $this->data['apaczka_insurance'] = $this->request->post['apaczka_insurance'];
        } else {
            $this->data['apaczka_insurance'] = $this->config->get('apaczka_insurance');
        }
        /**
         * @var integer apaczka_weight
         */
        if (isset($this->request->post['apaczka_weight'])) {
            $this->data['apaczka_weight'] = $this->request->post['apaczka_weight'];
        } else {
            $this->data['apaczka_weight'] = $this->config->get('apaczka_weight');
        }
        /**
         * @var integer apaczka_orderPickupType - typ odbioru przesylki dop wartosci to (COURIER, SELF, EVERYDAY, PHONE)
         */
        if (isset($this->request->post['apaczka_orderPickupType'])) {
            $this->data['apaczka_orderPickupType'] = $this->request->post['apaczka_orderPickupType'];
        } else {
            $this->data['apaczka_orderPickupType'] = $this->config->get('apaczka_orderPickupType');
        }
        /**
         * @var table apaczka_emails[case] - kogo i kiedy informujemy.  R-odbiorca paczki, S-wysylajacy.  
         * Mozliwe przypadki to: RDelivered, SDelivered, RExeption, SExeption, RNew, SNew, RSent, SSent                   
         *              Delivered - informacja o dostarczeniu 
         *              Exception - informacja w razie niepowodzenia
         *              New - informacja o powstaniu zamowienia
         *              Sent- informacja o wyslaniu
         */
        if(isset($this->request->post['apaczka_emails'])){
        $this->data['apaczka_emails'] = $this->request->post['apaczka_emails'];
        } else {
            $this->data['apaczka_emails'] = $this->config->get('apaczka_emails');
        }
        //*************************************************************************************
        
        if (isset($this->request->post['apaczka_sender_name'])) {
            $this->data['apaczka_sender_name'] = $this->request->post['apaczka_sender_name'];
        } else {
            $this->data['apaczka_sender_name'] = $this->config->get('apaczka_sender_name');
        }

        if (isset($this->request->post['apaczka_sender_contactName'])) {
            $this->data['apaczka_sender_contactName'] = $this->request->post['apaczka_sender_contactName'];
        } else {
            $this->data['apaczka_sender_contactName'] = $this->config->get('apaczka_sender_contactName');
        }

        if (isset($this->request->post['apaczka_sender_address1'])) {
            $this->data['apaczka_sender_address1'] = $this->request->post['apaczka_sender_address1'];
        } else {
            $this->data['apaczka_sender_address1'] = $this->config->get('apaczka_sender_address1');
        }

        if (isset($this->request->post['apaczka_sender_address2'])) {
            $this->data['apaczka_sender_address2'] = $this->request->post['apaczka_sender_address2'];
        } else {
            $this->data['apaczka_sender_address2'] = $this->config->get('apaczka_sender_address2');
        }

        if (isset($this->request->post['apaczka_sender_postcode'])) {
            $this->data['apaczka_sender_postcode'] = $this->request->post['apaczka_sender_postcode'];
        } else {
            $this->data['apaczka_sender_postcode'] = $this->config->get('apaczka_sender_postcode');
        }

        if (isset($this->request->post['apaczka_sender_city'])) {
            $this->data['apaczka_sender_city'] = $this->request->post['apaczka_sender_city'];
        } else {
            $this->data['apaczka_sender_city'] = $this->config->get('apaczka_sender_city');
        }

        if (isset($this->request->post['apaczka_sender_email'])) {
            $this->data['apaczka_sender_email'] = $this->request->post['apaczka_sender_email'];
        } else {
            $this->data['apaczka_sender_email'] = $this->config->get('apaczka_sender_email');
        }

        if (isset($this->request->post['apaczka_sender_phone'])) {
            $this->data['apaczka_sender_phone'] = $this->request->post['apaczka_sender_phone'];
        } else {
            $this->data['apaczka_sender_phone'] = $this->config->get('apaczka_sender_phone');
        }

        if (isset($this->request->post['apaczka_account'])) {
            $this->data['apaczka_account'] = $this->request->post['apaczka_account'];
        } else {
            $this->data['apaczka_account'] = $this->config->get('apaczka_account');
        }

        $this->load->model('localisation/tax_class');

        $this->data['tax_classes'] = $this->model_localisation_tax_class->getTaxClasses();

        $this->load->model('shipping/apaczka');

        $this->template = 'shipping/apaczka.tpl';
        $this->children = array(
            'common/header',
            'common/footer'
        );

        $this->response->setOutput($this->render());
    }

    private function validate() {

        if (!$this->user->hasPermission('modify', 'shipping/flat')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (!$this->error) {
            return true;
        } else {
            return false;
        }
    }

}

?>
